/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.genmodel.typesystem

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl
import org.eclipse.xtend.lib.annotations.Accessors
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sgen.util.BuiltinDeclarationNames

/**
 * @author rbeckmann
 * 
 */
@Accessors(PUBLIC_GETTER)
@Singleton
class BuiltinDeclarations implements BuiltinDeclarationNames {
	protected TypesFactory typesFactory
	protected ITypeSystem typeSystem

	protected Property sct_version
	protected Property sct_file
	protected Property timestamp
	protected Property hostname
	protected Property username
	protected Property sha256

	protected Resource builtinResource

	@Inject
	new(ITypeSystem typeSystem) {
		this.typesFactory = TypesFactory.eINSTANCE
		this.typeSystem = typeSystem
		builtinResource = new XMIResourceImpl
		val stringtype = typeSystem.getType(ITypeSystem.STRING)
		sct_version = createProperty(SCT_VERSION_VAR, stringtype)
		timestamp = createProperty(TIMESTAMP_VAR, stringtype)
		hostname = createProperty(HOSTNAME_VAR, stringtype)
		username = createProperty(USER_VAR, stringtype)
		sct_file = createProperty(SCTFILE, stringtype)
		sha256 = createProperty(SHA256, stringtype)
	}

	def protected Property createProperty(String name, Type type) {
		typesFactory.createProperty => [ prop |
			builtinResource.contents += prop

			prop.name = name
			prop.typeSpecifier = typesFactory.createTypeSpecifier => [
				it.type = type
			]
			prop.const = false
			prop.readonly = false
		]
	}

	def getGlobalDeclarations() {
		#[
			sct_version,
			timestamp,
			hostname,
			username
		]
	}
	
	def getStatechartLocalDeclarations() {
		#[
			sct_file,
			sha256
		]
	}

}
