/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.java.library.impl

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import com.yakindu.sctunit.generator.base.library.impl.BaseFeatureTypeLibraryProvider

class JavaSGenFeatureTypeLibraryProvider extends BaseFeatureTypeLibraryProvider {
	def naming() {
		createFeatureType => [
			name = "Naming"
			optional = true
			parameters += createFeatureParameter => [
				name = "basePackage"
				parameterType = getType(STRING)
			]
		]
	}

	def statechartNaming() {
		createFeatureType => [
			name = "StatechartNaming"
			optional = true
			parameters += createFeatureParameter => [
				name = "libraryPackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "basePackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "typeName"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "libraryTargetFolder"
				parameterType = getType(STRING)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "SCTUnit Java Generator"
			types += naming()
			types += statechartNaming()
		]
	}
}
