/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.annotations.VisibilityAnnotations
import java.util.List

/**
 * Defines a code pattern for C# visibility declarations. This visibility is derived from the default base types VisibilityAnnotation.
 * 
 * @author Axel Terfloth
 */
 class CsharpVisibility extends VisibilityAnnotations {
	
	public static String INTERNAL_ANNOTATION = "__internal__"
	public static List<String> ANNOTATIONS = #[INTERNAL_ANNOTATION,PUBLIC_ANNOTATION,PROTECTED_ANNOTATION,PRIVATE_ANNOTATION]
	
	@Inject protected extension TypeBuilder
	
	override getVisibility(AnnotatableElement it) {
		for (a : ANNOTATIONS) {
			if(getAnnotationOfType(a) !== null) return a
		}
	}
	
	def <T extends AnnotatableElement> T _internal(T e) {
		e._annotate(INTERNAL_ANNOTATION)
	}
	
	def isInternal(AnnotatableElement it) {
		getAnnotationOfType(INTERNAL_ANNOTATION) !== null
	}
	
	def String csharpVisibility(AnnotatableElement it) {
		
		if ( it.isPrivate ) 
			return "private"
		else if ( it.isProtected )
			return "protected"
		else if (it.isInternal)
			return "internal"
		else
			return "public"
	}
	
	override visibilityName(String it){
		switch (it) {
			case it === PUBLIC_ANNOTATION: '''public'''
			case it === PROTECTED_ANNOTATION: '''protected'''
			case it === PRIVATE_ANNOTATION: '''private'''
			case it === INTERNAL_ANNOTATION: '''internal'''
		}
	}
	
}
