/**
* Copyright (c) 2016 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Thomas Kutz - itemis AG
*
*/
package com.yakindu.sct.domain.c.runtime.resource

import com.google.common.collect.Maps
import java.nio.file.Path
import com.google.inject.Inject
import com.yakindu.sct.commons.PathHelper
import java.util.Map

/**
 * @author Thomas Kutz - Initial contribution and API
 */
class CachingPathResolver {
	
	@Inject protected extension PathHelper
	
	val Map<String,Path> cache = Maps.newHashMap
	
	def resolve(String filePath) {
		cache.computeIfAbsent(filePath, [toPath])
	}
}