/**
 * Copyright (c) 2019 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * Thomas Kutz - itemis AG
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource

import org.eclipse.core.resources.IResource

import static org.eclipse.core.resources.IResource.CHECK_ANCESTORS

class LinkedFolderResolver {
	
	def resolve(IResource file) {
		val allFiles = file.getWorkspace().getRoot().findFilesForLocationURI(file.getLocationURI());
		val found = allFiles.findFirst[!isLinked(CHECK_ANCESTORS)]
		return found ?: file
	}
}