/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.resource.headless

import com.yakindu.sct.domain.c.runtime.CRuntimeActivator
import com.yakindu.sct.domain.c.runtime.resource.CHeaderResource
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.URI
import org.eclipse.xtext.naming.QualifiedName

/**
 * @author rbeckmann
 * 
 */
class HeadlessCHeaderResource extends CHeaderResource {

	override java.nio.file.Path getResourceLocation() {
		return URI.toPath
	}

	override createRootPackage() {
		rootPackage = createPackage => [
			it.domainID = CRuntimeActivator.C_DOMAIN_ID
			it.name = computePackageName(getURI())
			_no_namespace
		]
	}

	override computePackageName(URI uri) {
		val toFileString = uri.isFile ? uri.toFileString : uri.toPlatformString(true)
		if (toFileString === null)
			return null;
		
		val headerPath = Path.fromOSString(toFileString)

		val wsPath = ResourcesPlugin.workspace.root.location
		if (wsPath.isPrefixOf(headerPath)) {
			val wsRelativePath = headerPath.makeRelativeTo(wsPath)
			val projectPath = wsRelativePath.segment(0);
			val projectRelativePath = wsRelativePath.makeRelativeTo(Path.fromOSString(projectPath))
			return QualifiedName.create(projectRelativePath.removeFileExtension.segments.map[convertToValidIdentifier]).toString
		}
		return QualifiedName.create(headerPath.removeFileExtension.lastSegment.convertToValidIdentifier).toString
	}

}
