/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.scxml

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.BinaryExpression
import com.yakindu.base.expressions.expressions.BinaryLiteral
import com.yakindu.base.expressions.expressions.BoolLiteral
import com.yakindu.base.expressions.expressions.ConditionalExpression
import com.yakindu.base.expressions.expressions.DoubleLiteral
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.HexLiteral
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.ParenthesizedExpression
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.expressions.expressions.TypeCastExpression
import com.yakindu.base.expressions.expressions.UnaryExpression
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.naming.IQualifiedNameProvider

import static extension org.apache.commons.lang.StringEscapeUtils.*

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class SCXMLExpressions {

	@Inject extension protected IQualifiedNameProvider
	@Inject extension ITypeSystem

	def dispatch CharSequence code(ElementReferenceExpression it) {
		'''«it.reference.fullyQualifiedName.toString»«reference.call(it)»'''
	}

	def dispatch CharSequence code(FeatureCall it) {
		'''«it.feature.fullyQualifiedName.toString»«feature.call(it)»'''
	}

	protected def CharSequence call(EObject it,
		ArgumentExpression exp) '''«IF it instanceof Operation»(«FOR arg : exp.expressions SEPARATOR ", "»«arg.code»«ENDFOR»);«ENDIF»'''

	def dispatch CharSequence code(ActiveStateReferenceExpression it) {
		'''In('«value.fullyQualifiedName.toString»')'''
	}

	def dispatch code(EventValueReferenceExpression it) {
		'''_event.data'''
	}

	def dispatch code(EventRaisingExpression it) {
		'''
			<send event="«event.definition.fullyQualifiedName.toString»">
			«IF value !== null»
				<content expr="«value.code»" />
			«ENDIF»
			</send>
		'''
	}

	def dispatch CharSequence code(BinaryExpression it) {
		leftOperand.code.toString.trim + " " + operator.literal.toString.trim.escapeXml + " " + rightOperand.code
	}

	def dispatch CharSequence code(UnaryExpression it) {
		operator.literal + operand.code
	}

	def dispatch CharSequence code(PostFixUnaryExpression it) {
		operand.code + operator.literal
	}

	def dispatch CharSequence code(AssignmentExpression it) {
		it.operator
		''' <assign location="«varRef.code»" expr="«expression.code»"/>'''
	}

	def dispatch CharSequence code(ConditionalExpression it) '''«condition.code» ? «trueCase.code» : «falseCase.code»'''

	def dispatch CharSequence code(PrimitiveValueExpression it) '''«value.code»'''

	def dispatch CharSequence code(ParenthesizedExpression it) '''(«expression.code»)'''

	def dispatch CharSequence code(
		TypeCastExpression it) '''«IF type.isSame(getType(ITypeSystem.INTEGER))»Math.floor(«ENDIF»«operand.code»«IF type.isSame(getType(ITypeSystem.INTEGER))»)«ENDIF»'''

	def dispatch CharSequence code(StringLiteral it) ''''«value.replace("\"", "\\\"")»'«»'''

	def dispatch CharSequence code(IntLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(DoubleLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(FloatLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(HexLiteral it) '''0x«Long::toHexString(value)»'''

	def dispatch CharSequence code(BinaryLiteral it) '''0b«Long::toBinaryString(value)»'''

	def dispatch CharSequence code(BoolLiteral it) '''«value.toString»'''

	def dispatch CharSequence code(NullLiteral expression) { 'null' }

	def dispatch CharSequence code(EObject it) {
		throw new IllegalStateException("No dispatch function for " + getClass().name)
	}

	def dispatch definition(ElementReferenceExpression it) {
		if(reference instanceof Declaration) reference as Declaration
	}

	def dispatch definition(FeatureCall it) {
		if(feature instanceof Declaration) feature as Declaration
	}

	def dispatch definition(Expression it) {
		null
	}
		
	def dispatch executableContent(Expression it)	'''
		<script>
			«code»
		</script>
	'''
	
	def dispatch executableContent(EventRaisingExpression it) {
		code
	}
	
	def dispatch executableContent(AssignmentExpression it) {
		code
	}
}
