/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.features

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

class OutEventObservables {
	
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension Naming
	@Inject extension SExecExtensions
	@Inject extension GenmodelEntries
	@Inject extension StringHelper
	
	
	def getEventType(Event it) {
		if (hasValue) {
			val typeName = typeSpecifier.targetLanguageName
			return if (type instanceof ComplexType) typeName else typeName.toFirstUpper
		}
		return "Void"
	}
	
	def getObservableGetterName(Event it) '''get«identifier.toString.toFirstUpper»'''
	
	def getObservableName(Event it) '''«identifier»Observable'''
	
	def getObserverName(Event shadowEvent) '''«shadowEvent.name»_observer'''
	
	def getObserverType(Event it) '''«observerClass»<«eventType»>'''
	
	def getObservableType(Event it) '''«observableClass»<«eventType»>'''
	
	def observableClass() { "Observable" }
	
	def observerClass() { "Observer" }
	
	def rxPackage(GeneratorEntry it) { libraryPackage + ".rx" }
	def rxPackagePath(GeneratorEntry it) { rxPackage.toPath }
}