/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.generator.java.Naming

class TimingFunctions {
	
	@Inject extension SExecExtensions
	@Inject extension Synchronized
	@Inject extension Naming
	@Inject protected extension TraceCode
	
	
	def timingFunctions(ExecutionFlow flow) '''
		«IF flow.timed»
			public «sync»void setTimerService(«iTimerService» «timerServiceInstance») {
				this.«timerServiceInstance» = «timerServiceInstance»;
			}
			
			public «iTimerService» getTimerService() {
				return «timerServiceInstance»;
			}
			
			public «sync»void raiseTimeEvent(int eventID) {
				timeEvents[eventID] = true;
				«flow.traceTimeEventRaised('eventID')»
			}

		«ENDIF»
	'''
}