/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.lifecycle

import com.google.inject.Inject
import com.yakindu.sct.generator.java.FlowCode
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions

class IsFinal implements com.yakindu.sct.generator.core.submodules.lifecycle.IsFinal {
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension FlowCode
	@Inject protected extension StateVectorExtensions
	@Inject protected extension GenmodelEntries
	@Inject protected extension Synchronized
	
	override isFinal(ExecutionFlow flow) {
		val finalStateImpactVector = flow.finalStateImpactVector

		'''
			/** 
			«IF !finalStateImpactVector.isCompletelyCovered»
			* Always returns 'false' since this state machine can never become final.
			*
			«ENDIF»
			* @see IStatemachine#isFinal()
			*/
			public «sync»boolean isFinal() {
		''' +

		// only if the impact vector is completely covered by final states the state machine
		// can become final

			{if (finalStateImpactVector.isCompletelyCovered) {
			'''	return «FOR i : 0 ..<finalStateImpactVector.size SEPARATOR ' && '»(«FOR fs : finalStateImpactVector.get(i) SEPARATOR ' || '»stateVector[«i»] == «
							IF fs.stateVector.offset == i
								»State.«fs.stateName»«
							ELSE
								»State.«nullStateName»«
							ENDIF»«
						ENDFOR»)«ENDFOR»;
		'''} else {
		'''	return false;
		'''} }
		
		+ '''}
		'''
	}
	
}