/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.lifecycle

import com.google.inject.Inject
import com.yakindu.base.types.TypesUtil
import com.yakindu.sct.generator.java.FlowCode
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions

class IsStateActive implements com.yakindu.sct.generator.core.submodules.lifecycle.IsStateActive {
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension FlowCode
	@Inject protected extension StateVectorExtensions
	@Inject protected extension GenmodelEntries
	@Inject protected extension Synchronized
	@Inject protected extension TypesUtil
	
	override isStateActive(ExecutionFlow flow) '''
		/**
		* Returns true if the given state is currently active otherwise false.
		*/
		public «sync»boolean isStateActive(State state) {

			switch (state) {
			«FOR s : flow.states»
			case «s.stateName»:
				return «IF s.leaf»stateVector[«s.stateVector.offset»] == State.«s.stateName»«ELSE»stateVector[«s.stateVector.offset»].ordinal() >= State.
						«s.stateName».ordinal()&& stateVector[«s.stateVector.offset»].ordinal() <= State.«s.subStates.lastOrNull.stateName».ordinal()«ENDIF»;
			«ENDFOR»
			default:
				return false;
			}
		}

	'''
	
}