/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.types

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgraph.util.StatechartUtil

import static com.yakindu.base.types.typesystem.ITypeSystem.*

/**
 * @author andreas muelder
 */
class JavaTypeSystemAccess implements ICodegenTypeSystemAccess {

	@Inject
	protected extension ITypeSystem ts
	
	@Inject
	protected extension Naming
	
	@Inject
	protected extension StatechartUtil
	
	@Inject
	protected extension StatemachineTypes
	
	@Inject
	protected extension EventBuffer

	override String getTargetLanguageName(Type type) {
		val originalType = type?.originType
		switch (originalType) {
			case originalType === null || ts.isSame(originalType, getType(VOID)) : 'void'
			case ts.isReal(originalType): "double"
			case ts.isInteger(originalType): "long"
			case ts.isBoolean(originalType): "boolean"
			case ts.isString(originalType): "String"
			// multi SM
			EnumerationType case originalType.isOriginStatechart: originalType.getOriginStatechart.statemachineClassName + ".State"
			ComplexType case originalType.isOriginStatechart: originalType.getOriginStatechart.statemachineClassName
			ComplexType case type.isInternalStatemachineType: originalType.internalStatemachineInterfaceName
			
			case originalType.isEventBuffer: originalType.eventBufferTypeName
			
			default: "//" + this
		};
	}
	
	override getTargetLanguageName(TypeSpecifier typeSpecifier) {
		return getTargetLanguageName(typeSpecifier?.type)
	}
}
