/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

class MetaSource implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntries
	@Inject extension Naming
	@Inject extension FileNaming
	@Inject extension SExecExtensions
	@Inject extension CTypes
	
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#include "«(flow.metaModule.h).relativeTo(flow.metaModule.c)»"
				
		«sc_string.name» «flow.metaFeaturesProperty»[] = {
			"<nothing>",
			«FOR feature : flow.scopes.map[it | it.eventAndVariableDefinitions].flatten SEPARATOR ","»
			"«feature.metaName»"
			«ENDFOR»
		};
		
		«sc_string.name» «flow.metaStatesProperty»[] = {
			"<nostate>",
			«FOR state : flow.states SEPARATOR ","»
			"«state.name.removePrefix»"
			«ENDFOR»
		};
		'''
	}
	
	def protected removePrefix(String s){
		return s.substring(s.indexOf(".")+1)
	}
		
}