/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.yakindu.base.types.Operation
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.c.ConstantInitializationResolver
import com.yakindu.sct.generator.c.FlowCode
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.ISourceFragment
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author rbeckmann
 *
 */
class StatemachineSourceFragment implements ISourceFragment {
	@Inject protected extension Naming
	@Inject protected extension FileNaming
	@Inject protected extension GenmodelEntries
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject protected extension FlowCode
	@Inject protected extension ConstantInitializationResolver
	@Inject protected extension StateVectorExtensions
	@Inject protected extension ExpressionsChecker
	@Inject protected extension GeneratorPredicate
	
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension APIGenerator
	@Inject protected extension EventProcessing
	
	@Inject protected extension InternalFunctionsGenerator//TODO is this allowed?
	@Inject protected extension InterfaceFunctionsGenerator
	@Inject protected extension MethodGenerator

	override CharSequence fileComment(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''«entry.licenseText»'''
	}
	
	override CharSequence includes(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		
		#include "«(typesModule.h).relativeTo(module.c)»"
		«IF entry.tracingGeneric»
		#include "«(tracingModule.h).relativeTo(module.c)»"
		«ENDIF»
		
		#include "«(module.h).relativeTo(module.c)»"
		«IF timed || entry.tracingUsed || !it.operations.empty»
			#include "«(module.client.h).relativeTo(module.c)»"
		«ENDIF»
		
		«IF hasStringComparison || hasCharArrayAssignment»
		#include <string.h>
		«ENDIF»
		«IF modOnReal»#include <math.h>«ENDIF»
		/*! \file
		Implementation of the state machine '«name»'
		*/
		'''
	}
	
	override CharSequence declarations(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		«defines»
		
		«functionPrototypes»

		«reactMethods.map[it as Operation].declarations»

		«allMethods.filter[ !isPublic ].declarations»

		«observerCallbacksPrototypes»
		
		«constantDefinitions»
		
		«localVariableSetterPrototypes»
		
		«reassignPrototypes»
		
		'''
	}
	
	override CharSequence implementations(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		'''
		«functions»
		'''
	}
	
	def constantDefinitions(ExecutionFlow it) '''
		«FOR constant : constants»
			const «constant.typeSpecifier.targetLanguageName» «constant.access» = «constant.initialValue.resolveConstants»;
		«ENDFOR»
	'''
	
	def functions(ExecutionFlow it) '''	
		«IF entry.tracingGeneric»
		«tracing»
		
		«initWithTracing»
		«ENDIF»
		
		«init»
		
		«allMethods.filter[ isPublic ].implementation»
		
		«active»
		
		«final»
		
		«IF timed»
		«raiseTimeEvent»

		«ENDIF»
		«isStateActive»
		
		«allMethods.filter[ !isPublic ].implementation»
		
		«interfaceFunctions»
		
		«localVariableSetters»
		
		«reassignDeclarations»
		
		«functionImplementations»
		
		«reactMethods.map[it as Operation].implementation»
		
		«observerCallbacksImplementations»
		
		
	'''
}