/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules.eventdriven

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.submodules.StatechartTypes
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

/**
 * @author rbeckmann
 *
 */
@Singleton // Guice
class EventDrivenStatechartTypes extends StatechartTypes {

	@Inject protected extension EventQueue
	@Inject protected extension EventNaming
	@Inject protected extension GeneratorPredicate
	@Inject protected extension Naming
	@Inject protected extension CTypes
	
	override statemachineStructContent(ExecutionFlow it) {
		'''
		«super.statemachineStructContent(it)»
		«IF requiresInternalEventQueue»
		«eventQueueTypeName» «internalQueue»;
		«IF !userAllocatesInternalQueue»
		«internalEventStructTypeName» internal_buffer[«internalBufferSize»];
		«ENDIF»
		«ENDIF»
		«IF requiresIncomingEventQueue»
		«eventQueueTypeName» «inEventQueue»;
		«IF !userAllocatesInternalQueue»
		«internalEventStructTypeName» in_buffer[«inBufferSize»];
		«ENDIF»
		«ENDIF»
		'''
	}
	
	def generateEventsEnum(ExecutionFlow it) {
		if(!requiresEventQueue) return ''''''
		'''
		/* 
		 * Enum of event names in the statechart.
		 */
		typedef enum  {
			«invalidEventEnumName(it)» = «invalidEvent»«IF !queuedEvents.isEmpty»,«ENDIF»
			«FOR e : queuedEvents SEPARATOR ","»
				«eventEnumMemberName(e)»
			«ENDFOR»
		} «eventEnumName»;
		'''
	}
	
	def generateEventValueUnion(ExecutionFlow it) {
		if(!needsValueUnion) return ''''''
		'''
		/*
		 * Union of all possible event value types.
		 */
		typedef union {
			«FOR e : queuedEvents.withValue»
			«e.typeSpecifier.targetLanguageName» «eventValueUnionMemberName(e)»;
			«ENDFOR»
		} «eventValueUnionName»;
		'''
	}
	
	def generateEventStruct(ExecutionFlow it) {
		'''
		/*
		 * Struct that represents a single event.
		 */
		typedef struct {
			«eventEnumName» name;
			«IF needsValueUnion»
			«sc_bool.name» has_value;
			«eventValueUnionName» value;
			«ENDIF»
		} «internalEventStructTypeName»;
		'''
	}

	def generateEventQueue(ExecutionFlow it) {
		'''
		/*
		 * Queue that holds the raised events.
		 */
		typedef struct «eventQueueTypeName»_s {
			«internalEventStructTypeName» *events;
			«sc_integer.name» capacity;
			«sc_integer.name» pop_index;
			«sc_integer.name» push_index;
			«sc_integer.name» size;
		} «eventQueueTypeName»;
		'''
	}
}