/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 	Finlay Weegen - itemis AG
 * 
 */
package com.yakindu.sctunit.simulation.core.coverage

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.ReactionFired
import com.yakindu.sct.model.sexec.Trace
import com.yakindu.sct.model.sexec.TraceNodeExecuted
import com.yakindu.sct.model.sexec.TraceStateEntered
import com.yakindu.sct.model.sruntime.ExecutionContext
import com.yakindu.sct.simulation.core.sexec.interpreter.ITraceStepInterpreter
import org.eclipse.emf.ecore.EObject
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension
import com.yakindu.sct.simulation.core.coverage.MeasurementContext

class ModelVisitsTraceStepInterpreter implements ITraceStepInterpreter {

	@Inject protected extension MeasurementExtension
	@Inject protected extension MeasurementContext
	
	override evaluate(Trace trace, ExecutionContext context) {
		trace.coverage(context)
	}

	protected dispatch def coverage(TraceStateEntered it, ExecutionContext context) {
		it.state.sourceElement.increaseVisited
	}

	protected dispatch def coverage(ReactionFired it, ExecutionContext context) {
		it.reaction.sourceElement.increaseVisited
	}
	
	protected dispatch def coverage(TraceNodeExecuted it, ExecutionContext context) {
		it.node.sourceElement.increaseVisited
	}	

	protected dispatch def coverage(EObject fallback, ExecutionContext context) {
	}
	
	
	protected def increaseVisited(EObject it) {
		if (it !== null) {
			try {
				currentMeasurement?.forSubject(it)?.visits?.increase 
			} catch (Exception e) { // trace processing should never break the interpreter.
				e.printStackTrace
			}
		}		
	}	
}

