/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.types.Direction
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import java.util.ArrayList
import java.util.List

class EventRaisingCode {
	
	@Inject protected extension CppNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension ITypeSystem
	@Inject protected extension INamingService
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension FeatureCallSeparator
	@Inject protected extension GeneratorPredicate
	@Inject protected extension ShadowEventExtensions
	
	def CharSequence raiseEvent(EventRaisingExpression it, CharSequence valueCode) {
		if (event.definition.isExternal) {
			raiseExternalEvent(valueCode)
		} else {
			switch (event.definition.event.direction) {
				case Direction::IN: {
					return raiseInEvent(valueCode)
				}
				case Direction::OUT: {
					return raiseOutEvent(valueCode)
				}
				case Direction::LOCAL: {
					return raiseLocalEvent(valueCode)
				}
			}			
		}
	}
	
	def protected raiseExternalEvent(EventRaisingExpression it, CharSequence valueCode) 
		'''«event.context»«event.definition.event.asRaiser»(«IF value !== null»«valueCode»«ENDIF»)'''
		

	def protected raiseInEvent(EventRaisingExpression it, CharSequence valueCode) {
		raiseInEventStatements(valueCode).code
	}
		
		
	def protected List<CharSequence> raiseInEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		raiseDefaultEventStatements(valueCode)	
	}
	
		
	def protected raiseOutEvent(EventRaisingExpression it, CharSequence valueCode) {
		raiseOutEventStatements(valueCode).code
	}
		
		
	def protected List<CharSequence> raiseOutEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		val statements = new ArrayList<CharSequence>()
		
		if (useOutEventGetters) {
			statements += setEventGetterFlag
			if(value !== null)
				statements += setEventValue(valueCode)
		}
		
		if (useOutEventObservables)
			statements += '''«event.definition.event.observableAccess».next(«eventValueIfPresent»)'''
		
		val localOutEvent = event.definition.event.getLocalOutEvent
		if (localOutEvent !== null )
			statements += '''«localOutEvent.asRaiser»(«eventValueIfPresent»)'''

		return statements		
	}
		
	
	def protected code(Iterable<CharSequence> statements) {
		statements.join(";\n")
	}
		
	def protected raiseLocalEvent(EventRaisingExpression it, CharSequence valueCode) {
		raiseLocalEventStatements(valueCode).code
	}
	
	
	def protected List<CharSequence> raiseLocalEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		raiseDefaultEventStatements(valueCode)		
	}
	
	
	def protected List<CharSequence> raiseDefaultEventStatements(EventRaisingExpression it, CharSequence valueCode) {
		val statements = new ArrayList<CharSequence>()
		
		if (value !== null) statements += setEventValue(valueCode)
		statements += setEventGetterFlag

		return statements		
	}
	
	
		
	def protected setEventValue(EventRaisingExpression it, CharSequence valueCode) '''
		«IF value !== null»
			«event.definition.event.valueAccess» = «valueCode»«ENDIF»'''

	def protected setEventGetterFlag(EventRaisingExpression it) '''
		«event.definition.scope.namedInstanceAccess»«event.definition.name.asIdentifier.raised» = true'''


	def protected eventValueIfPresent(EventRaisingExpression it) '''«IF useOutEventGetters && value !== null»«event.definition.event.valueAccess»«ELSEIF value !== null»«value.code»«ENDIF»'''
}