/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Event
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp11.codepattern.EnumClassCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import org.eclipse.emf.ecore.EObject

/**
 * This extension defines a state machines event enumaration. 
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton class EventEnum {


	public static final String NO_EVENT = "NO_EVENT"
	public static final String EVENT_ENUM_NAME = "Event"
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	@Inject protected extension INamingService	
	@Inject protected extension Naming
	@Inject protected extension SExecExtensions
	@Inject protected extension SgraphExtensions
	@Inject protected extension StatemachineClass
	@Inject protected extension Documentation
	
	@Inject protected extension EventQueue
	
	@Inject protected extension GeneratorAssignment
	@Inject protected extension EnumClassCode
	@Inject protected extension OriginTracing
	
	def defineEventEnum(ExecutionFlow flow) {
		
		val e = createEnumerationType=> [
			documentation("Enumeration of all events which are consumed.")
			_public
			name = EVENT_ENUM_NAME
			enumerator += createEnumerator => [ it.name = NO_EVENT]
			flow.queuedEvents.forEach[ ev | 
				it.enumerator += createEnumerator => [ it.name = ev.enumeratorName]
			]
			flow.stateMachineClass.features += it	
		]
		
		e.generateDeclarationWith[ e.enumerationCode ]
	}  
	
	
	def eventEnum(ExecutionFlow it) {
		stateMachineClass.features.filter(EnumerationType).filter[ name == EVENT_ENUM_NAME].head
	}

		
	def noEventEnumerator(ExecutionFlow it) {
		eventEnum.enumerator.findFirst[ e | e.name == NO_EVENT ]		
	}
	
	
	
	def enumerator(Event it) {
		val eventEnumName = enumeratorName
		flow.eventEnum.enumerator.findFirst[ e | e.name == eventEnumName ]
	}
	

	def noEventEnumerator(EnumerationType it) {
		enumerator.findFirst[ e | e.name == NO_EVENT ]
	}


	def dispatch enumeratorName(Event it) {
		#[scope.interfaceName, name.asEscapedIdentifier].filter[!nullOrEmpty].join("_")
	}
	
	def dispatch enumeratorName(TimeEvent it) {
		val origin = it.origin
		val state = if ( origin instanceof EObject) origin.eContainerOfType(RegularState) else null
			
		"_te" + it.indexOf + "_" + (if (state !== null) state.shortName + "_" else "") 
	}
	
}
