/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 */
package com.yakindu.sct.domain.java.resource.trafo.types

import java.util.ArrayList
import java.util.Arrays
import java.util.List
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.InternalEObject
import org.eclipse.jdt.core.IJavaElement
import org.eclipse.jdt.core.IJavaProject
import org.eclipse.jdt.core.IPackageFragmentRoot
import org.eclipse.jdt.core.IType
import org.eclipse.jdt.core.Signature
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypesPackage
import com.yakindu.sct.domain.java.resource.ArchiveURI
import java.nio.file.FileSystem
import java.nio.file.FileSystems
import java.nio.file.Path
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot

/**
 * @author Rene Beckmann - Initial API and contribution
 */
class ProxyBuilder {
	
	def Type build(String typeName, IJavaProject project) {
		val type = project.findType(typeName)
		if (type === null) {
			return null
		}
		val typeUri = getURI(project.project.name, type, typeName)
		val ret = createProxy(TypesPackage.Literals.COMPLEX_TYPE, typeUri) as Type
		ret
	}
	
	def protected URI getURI(String contextProject, IType type, String typeName) {
		val packageFragmentRoot = type.getAncestor(IJavaElement.PACKAGE_FRAGMENT_ROOT) as IPackageFragmentRoot
		if (packageFragmentRoot.isArchive) {
			
			if (packageFragmentRoot instanceof JrtPackageFragmentRoot) {
				val jrtFileSystem = FileSystems.getFileSystem(java.net.URI.create("jrt:/"));			
				val objClassFilePath = jrtFileSystem.getPath("modules", new String(packageFragmentRoot.module.name), type.fullyQualifiedName.replace('.', '/') + ".class");
				val classFileURI = objClassFilePath.toUri
				return URI.createURI(classFileURI.toString).appendQuery(contextProject).appendFragment(type.fullyQualifiedName)
			}
			else {
				val List<String> packageSegments = new ArrayList(Arrays.asList(Signature.getSimpleNames(Signature.getQualifier(typeName))))
				packageSegments.add(type.elementName + ".class")
				var archiveURI = ArchiveURI.create(packageFragmentRoot, packageSegments)
				archiveURI = archiveURI.appendQuery(contextProject).appendFragment(type.fullyQualifiedName)
				return archiveURI
			}
		} else {
			val resource = type.resource
			val typeURI = URI.createPlatformResourceURI(resource.fullPath.toString, true).appendFragment(typeName)
			return typeURI
		}
	}
	
	def protected EObject createProxy(EClass eClass, URI uri) {
		val proxy = eClass.getEPackage().getEFactoryInstance().create(eClass) as InternalEObject
		proxy.eSetProxyURI(uri)
		return proxy
	}
}