/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Thomas Kutz - itemis AG
*
*/
package com.yakindu.sct.domain.java.ui.simulation

import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.types.Annotation
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Type
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sruntime.CompositeSlot
import com.yakindu.sct.simulation.core.sexec.interpreter.StextExpressionInterpreter
import org.eclipse.emf.ecore.EObject

import static extension org.eclipse.xtext.EcoreUtil2.*
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * 
 * @author Thomas Kutz - Initial API and contribution
 */
class JavaDomainExpressionInterpreter extends StextExpressionInterpreter {
	
	 override dispatch doExecute(EObject feature, CompositeSlot slot, ArgumentExpression exp) {
		slot.value
 	}
 	
 	/**
	 * In Java domain we want number literals to be treated like int types instead of long, so method dispatching works as expected, e.g. Integer.valueOf(42) 
	 */
	override dispatch valueLiteral(IntLiteral literal) {
		if (literal.isScheduleTimeEventValue || literal.isCycleBasedAnnotationArgument) {
			return super._valueLiteral(literal)
		}
		return literal.value
	}	
	
	override Object cast(Object value, Type type) {
		if (type instanceof ComplexType) {
			if (type.getName().equals(value.getClass.simpleName)) {
				return value
			}
		}
		return super.cast(value, type)
	}
	
	private def isCycleBasedAnnotationArgument(EObject obj) {
		val annotation = obj.getContainerOfType(Annotation)
		annotation !== null && annotation.type.name == StatechartAnnotations.CYCLE_BASED_ANNOTATION
	}
	
	private def isScheduleTimeEventValue(EObject obj) {
		obj.getContainerOfType(ScheduleTimeEvent) !== null
	}
	
}
