/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.java.ui.simulation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecExecution
import com.yakindu.sct.simulation.core.sexec.interpreter.SexecInterpreter
import java.lang.reflect.Field
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

/**
 * As PolymorphicDispatcher executes functions declared in the external source class on the actual source class instance,
 * when the user sets a variable the instance also has to be updated, not just the ExecSlots.
 * 
 * @author laszlo kovacs
 */
@Singleton
class JavaDomainSexecInterpreter extends SexecInterpreter {
	
	@Inject new(SexecExecution exec) {
		super(exec)
	}
	
	override setValue(Object slot, Object value) {
		slot.setJavaInstance(value)
		
		super.doSet(slot, value)
	}
	
	def protected setJavaInstance(Object slot, Object value){
		val propName = (slot as ExecutionSlot).name
		val ownerSlot = EcoreUtil2.getContainerOfType(slot as EObject, JavaObjectSlot)
		if (ownerSlot !== null){
			try {
		        // Try setter method first
		        val setterName = "set" + Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
		        val setter = ownerSlot.getValue().class.getMethod(setterName, value.getClass());
		        setter.invoke(ownerSlot.getValue(), value);
		    } catch (NoSuchMethodException e) {
		        // Fallback: try direct field access
		        val field = ownerSlot.getValue().class.getDeclaredField(propName) as Field
		        
		        try {
		        	// Field setter is not capable to set value for Long obj.
		       		field.set(ownerSlot.getValue(), value instanceof Long ? value.intValue : value);
		        } catch (NoSuchMethodException fieldExc) {
		        	
		        }
	    	}
    	}
	}
}