/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.jface.concurrent;

import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DeferredUnitOfWork<R, S>
implements IUnitOfWork<R, S> {
    protected long deferTime = 1000L;
    protected IUnitOfWork<R, S> actualWork;

    public DeferredUnitOfWork(IUnitOfWork<R, S> work, long defer) {
        this.deferTime = defer;
        this.actualWork = work;
    }

    public R exec(S state) throws Exception {
        Thread.sleep(this.deferTime);
        return (R)this.actualWork.exec(state);
    }

    public static <R, S> IUnitOfWork<R, S> deferred(IUnitOfWork<R, S> work, long defer) {
        if (work instanceof CancelableUnitOfWork) {
            return new Cancelable((CancelableUnitOfWork)work, defer);
        }
        return new DeferredUnitOfWork<R, S>(work, defer);
    }

    public static class Cancelable<R, S>
    extends CancelableUnitOfWork<R, S> {
        protected long deferTime = 1000L;
        protected CancelableUnitOfWork<R, S> actualWork;

        public Cancelable(CancelableUnitOfWork<R, S> work, long defer) {
            this.deferTime = defer;
            this.actualWork = work;
        }

        public void setCancelIndicator(CancelIndicator cancelIndicator) {
            super.setCancelIndicator(cancelIndicator);
            this.actualWork.setCancelIndicator(cancelIndicator);
        }

        public R exec(S state, CancelIndicator cancelIndicator) throws Exception {
            Thread.sleep(this.deferTime);
            return (R)this.actualWork.exec(state, cancelIndicator);
        }
    }
}

