/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ext;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.yakindu.sct.model.sgen.FeatureParameter;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

public class FeatureTypeLibraryExportAnalyzer {
    protected FeatureTypeLibrary library;
    public static final String FEATURE_CONTAINER = "featureContainer";
    @Inject
    IQualifiedNameProvider qualifiedNameProvider;

    public FeatureTypeLibraryExportAnalyzer(FeatureTypeLibrary library) {
        this.library = library;
    }

    public List<IEObjectDescription> computeExportedObjects() {
        Iterator contents = this.library.getTypes().iterator();
        ArrayList result = Lists.newArrayList();
        while (contents.hasNext()) {
            FeatureType eObject = (FeatureType)contents.next();
            QualifiedName qualifiedName = (QualifiedName)this.qualifiedNameProvider.apply((Object)eObject);
            if (qualifiedName == null) continue;
            if (eObject instanceof FeatureParameter) {
                this.addFeatureParameter(result, (EObject)eObject, qualifiedName);
                continue;
            }
            result.add(new EObjectDescription(qualifiedName, (EObject)eObject, (Map)Maps.newHashMap()));
            if (!(eObject instanceof FeatureType)) continue;
            FeatureType ft = eObject;
            for (FeatureParameter param : ft.getParameters()) {
                this.addFeatureParameter(result, (EObject)param, (QualifiedName)this.qualifiedNameProvider.apply((Object)param));
            }
        }
        return result;
    }

    private void addFeatureParameter(List<IEObjectDescription> result, EObject eObject, QualifiedName qualifiedName) {
        HashMap<String, String> userData = new HashMap<String, String>();
        userData.put(FEATURE_CONTAINER, this.getFqName(eObject));
        result.add((IEObjectDescription)new EObjectDescription(qualifiedName, eObject, userData));
    }

    private String getFqName(EObject eObject) {
        return this.qualifiedNameProvider.getFullyQualifiedName((EObject)((FeatureParameter)eObject).getFeatureType()).toString();
    }
}

