/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.report;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Reaction;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SubchartDFS;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sctunit.coverage.report.CoverageColors;
import com.yakindu.sctunit.coverage.report.HTMLCoverageReport;
import com.yakindu.sctunit.coverage.report.ReportElement;
import com.yakindu.sctunit.coverage.report.ReportExtensions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.osgi.framework.Bundle;

public class CoverageReportStore {
    private CopyToImageUtil renderer;
    @Extension
    private MeasurementExtension mExtension;
    @Extension
    private ReportExtensions rExtension;
    private Measurement measurement;
    private ArrayList<ReportElement> reportElements = new ArrayList();

    public CoverageReportStore(Measurement measurement, CopyToImageUtil renderer) {
        ReportExtensions _reportExtensions;
        MeasurementExtension _measurementExtension;
        this.measurement = measurement;
        this.renderer = renderer;
        this.mExtension = _measurementExtension = new MeasurementExtension();
        this.rExtension = _reportExtensions = new ReportExtensions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveReportFolder(java.nio.file.Path path, String filename) {
        String _string = path.getParent().toString();
        String _plus = _string + "/";
        String _plus_1 = _plus + filename;
        final String zipPath = Paths.get(_plus_1, new String[0]).toString();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                FileOutputStream outStream = new Functions.Function0<FileOutputStream>(){

                    public FileOutputStream apply() {
                        try {
                            return new FileOutputStream(zipPath);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                }.apply();
                try {
                    try (ZipOutputStream zipOutStream = new ZipOutputStream(outStream);){
                        this.populateReportElements(this.measurement, zipOutStream);
                        String report = new HTMLCoverageReport(this.measurement).generate(this.reportElements);
                        this.addCoverageFolderToZipStream(zipPath, zipOutStream);
                        final File reportFile = new File("index.html");
                        reportFile.createNewFile();
                        Throwable throwable2 = null;
                        Object var14_20 = null;
                        try (FileWriter fileWriter = new Functions.Function0<FileWriter>(){

                            public FileWriter apply() {
                                try {
                                    return new FileWriter(reportFile);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        }.apply();){
                            fileWriter.write(report);
                            this.addFileWithNameToZipStream(report.getBytes(), "index.html", zipOutStream);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (outStream == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (outStream == null) throw throwable;
                    outStream.close();
                    throw throwable;
                }
                outStream.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable _t) {
            if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
            Exception exception = (Exception)_t;
            exception.printStackTrace();
            return;
        }
    }

    public void populateReportElements(Measurement measurement, ZipOutputStream zipOutStream) {
        Iterable<ReportElement> _reportElements = this.reportElements(measurement.getSubject(), measurement);
        Iterables.addAll(this.reportElements, _reportElements);
        Consumer<ReportElement> _function = it -> {
            int i = 0;
            while (i < it.getImages().size()) {
                byte[] _get = it.getImages().get(i);
                String _imageName = this.rExtension.imageName((ReportElement)it, i);
                String _plus = "/img/" + _imageName;
                this.addFileWithNameToZipStream(_get, _plus, zipOutStream);
                ++i;
            }
        };
        this.reportElements.forEach(_function);
    }

    protected Iterable<ReportElement> _reportElements(Statechart it, Measurement measurement) {
        ArrayList _arrayList = new ArrayList();
        Procedures.Procedure1 _function = it_1 -> {
            ArrayList<byte[]> _provideImages = this.provideImages(measurement);
            ReportElement _reportElement = new ReportElement(measurement, _provideImages);
            it_1.add(_reportElement);
        };
        return (Iterable)ObjectExtensions.operator_doubleArrow(_arrayList, (Procedures.Procedure1)_function);
    }

    protected Iterable<ReportElement> _reportElements(Object it, Measurement measurement) {
        Functions.Function1 _function = it_1 -> this.reportElements(it_1.getSubject(), (Measurement)it_1);
        return Iterables.concat((Iterable)ListExtensions.map((List)measurement.getChildren(), (Functions.Function1)_function));
    }

    protected Iterable<ReportElement> _reportElements(Void it, Measurement measurement) {
        Functions.Function1 _function = it_1 -> this.reportElements(it_1.getSubject(), (Measurement)it_1);
        return Iterables.concat((Iterable)ListExtensions.map((List)measurement.getChildren(), (Functions.Function1)_function));
    }

    public void addCoverageFolderToZipStream(String zipPath, ZipOutputStream zipOutStream) {
        try {
            Bundle bundle = Platform.getBundle((String)"com.yakindu.sctunit.coverage.ui");
            ArrayDeque<String> resources = new ArrayDeque<String>();
            resources.offer("ressource/coverageReport/");
            while (!resources.isEmpty()) {
                String resource = (String)resources.poll();
                boolean _endsWith = resource.endsWith("/");
                if (_endsWith) {
                    Procedures.Procedure1 _function = it -> resources.add((String)it);
                    IteratorExtensions.forEach(bundle.getEntryPaths(resource).asIterator(), (Procedures.Procedure1)_function);
                    continue;
                }
                Path path = new Path(resource);
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                InputStream inputStream = url.openStream();
                byte[] bytes = inputStream.readAllBytes();
                this.addFileWithNameToZipStream(bytes, path.removeFirstSegments(2).toString(), zipOutStream);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void readBytesFromFile(File file, ZipOutputStream zipOutStream, String zipPath) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            this.addFileWithNameToZipStream(bytes, file.getName(), zipOutStream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void addFileWithNameToZipStream(byte[] fileBytes, String filename, ZipOutputStream zipOutStream) {
        try {
            ZipEntry _zipEntry = new ZipEntry(filename);
            zipOutStream.putNextEntry(_zipEntry);
            zipOutStream.write(fileBytes);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ArrayList<byte[]> provideImages(Measurement measurement) {
        boolean _notEquals;
        ArrayList<byte[]> _xblockexpression = null;
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        EObject _subject = measurement.getSubject();
        Statechart mainStatechart = (Statechart)_subject;
        Functions.Function1 _function = p -> SubchartDFS.getStatechart((Property)p);
        Set subcharts = IterableExtensions.toSet((Iterable)ListExtensions.map((List)SubchartDFS.getSubcharts((Statechart)mainStatechart), (Functions.Function1)_function));
        Collection<Diagram> diagrams = this.returnDiagramsFromStatechart(mainStatechart);
        for (Diagram diagram : diagrams) {
            Diagram diagramCopy = (Diagram)EcoreUtil.copy((EObject)diagram);
            images.add(this.generateImage(diagramCopy, measurement));
        }
        Functions.Function1 _function_1 = it -> null;
        boolean bl = _notEquals = !Objects.equals(subcharts, _function_1);
        if (_notEquals) {
            for (Statechart subchart : subcharts) {
                Collection<Diagram> _returnDiagramsFromStatechart = this.returnDiagramsFromStatechart(subchart);
                for (Diagram diagram_1 : _returnDiagramsFromStatechart) {
                    Diagram diagramCopy = (Diagram)EcoreUtil.copy((EObject)diagram_1);
                    images.add(this.generateImage(diagramCopy, measurement));
                }
            }
        }
        _xblockexpression = images;
        return _xblockexpression;
    }

    public Collection<Diagram> returnDiagramsFromStatechart(Statechart statechart) {
        Collection diagramCollection;
        Collection _xblockexpression = null;
        _xblockexpression = diagramCollection = EcoreUtil.getObjectsByType((Collection)statechart.eResource().getContents(), (EClassifier)NotationPackage.Literals.DIAGRAM);
        return _xblockexpression;
    }

    public byte[] generateImage(final Diagram diagram, final Measurement measurement) {
        try {
            diagram.eSetDeliver(false);
            String _name = measurement.getName();
            String _plus = "coverage" + _name;
            String _string = new String(_plus);
            URI _createURI = URI.createURI((String)_string);
            XMIResourceImpl resource = new XMIResourceImpl(_createURI);
            EList _contents = resource.getContents();
            _contents.add((Object)diagram);
            ResourceSetImpl set = new ResourceSetImpl();
            EList _resources = set.getResources();
            _resources.add((Object)resource);
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)set);
            CommandStack _commandStack = editingDomain.getCommandStack();
            _commandStack.execute((Command)new RecordingCommand(editingDomain){

                public void doExecute() {
                    ArrayList<View> _arrayList = new ArrayList<View>();
                    CoverageReportStore.this.highlightCoverage(diagram, measurement, _arrayList);
                }
            });
            ImageFileFormat _resolveImageFormat = ImageFileFormat.resolveImageFormat((String)"svg");
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            byte[] image = this.renderer.copyToImageByteArray(diagram, -1, -1, _resolveImageFormat, (IProgressMonitor)_nullProgressMonitor, PreferencesHint.USE_DEFAULTS, false);
            editingDomain.dispose();
            return image;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void highlightCoverage(Diagram diagram, Measurement measurement, ArrayList<View> highlightingList) {
        Functions.Function1 _function = it -> this.considered(it.getElement());
        Procedures.Procedure1 _function_1 = it -> this.applyHighlightingColour((View)it, this.getHighlightingColour((View)it, measurement));
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), View.class), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
    }

    protected void applyHighlightingColour(View it, RGB colour) {
        EObject _element = it.getElement();
        if (_element instanceof Reaction) {
            Iterable _filter = Iterables.filter((Iterable)it.getStyles(), ConnectorStyle.class);
            ConnectorStyle _head = null;
            if (_filter != null) {
                _head = (ConnectorStyle)IterableExtensions.head((Iterable)_filter);
            }
            if (_head != null) {
                _head.setLineColor(FigureUtilities.RGBToInteger((RGB)colour).intValue());
            }
        } else {
            EObject _element_1 = it.getElement();
            if (_element_1 instanceof Vertex) {
                EList _styles = it.getStyles();
                Iterable _filter_1 = null;
                if (_styles != null) {
                    _filter_1 = Iterables.filter((Iterable)_styles, ShapeStyle.class);
                }
                ShapeStyle _head_1 = null;
                if (_filter_1 != null) {
                    _head_1 = (ShapeStyle)IterableExtensions.head((Iterable)_filter_1);
                }
                if (_head_1 != null) {
                    _head_1.setFillColor(FigureUtilities.RGBToInteger((RGB)colour).intValue());
                }
            }
        }
    }

    protected RGB getHighlightingColour(View view, Measurement measurement) {
        EObject elem = view.getElement();
        Measurement.StateTransitionCoverage stc = this.mExtension.coverage(this.mExtension.forSubject(measurement, (Object)elem));
        float _xifexpression = 0.0f;
        _xifexpression = stc == null ? 0.0f : stc.coverage;
        float coverage = _xifexpression;
        if (coverage == 1.0f) {
            return CoverageColors.GREEN.getRGB();
        }
        if (coverage == 0.0f) {
            return CoverageColors.RED.getRGB();
        }
        return CoverageColors.YELLOW.getRGB();
    }

    protected boolean considered(EObject eObject) {
        return eObject instanceof Reaction || eObject instanceof Vertex;
    }

    @XbaseGenerated
    protected Iterable<ReportElement> reportElements(Object it, Measurement measurement) {
        if (it instanceof Statechart) {
            return this._reportElements((Statechart)it, measurement);
        }
        if (it == null) {
            return this._reportElements((Void)null, measurement);
        }
        if (it != null) {
            return this._reportElements(it, measurement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, measurement).toString());
    }
}

