/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.report;

import com.google.common.collect.Iterators;
import com.yakindu.base.types.Property;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.FinalState;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sctunit.coverage.report.CoverageReportAdapterFactoryLabelProvider;
import com.yakindu.sctunit.coverage.report.ICoverageReport;
import com.yakindu.sctunit.coverage.report.ReportElement;
import com.yakindu.sctunit.coverage.report.ReportExtensions;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class HTMLCoverageReport
implements ICoverageReport {
    @Extension
    private MeasurementExtension mExtension;
    @Extension
    private ReportExtensions rExtension;
    private final ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final CoverageReportAdapterFactoryLabelProvider labelProvider = new CoverageReportAdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
    private final Measurement measurement;
    private ArrayList<Statechart> statechartList = new ArrayList();
    private ArrayList<Measurement> testCases = new ArrayList();
    private BigDecimal avgTotalCoverage = new BigDecimal(0.0);
    private int statechartCounter = 0;
    private int idCounter = 0;
    private int iconCounter = 0;
    private int treeTableCounter = 0;
    private int numberOfImages;
    private ArrayList<ReportElement> reportElements;
    private int numberOfTestCases;

    public HTMLCoverageReport(Measurement measurement) {
        ReportExtensions _reportExtensions;
        MeasurementExtension _measurementExtension;
        this.measurement = measurement;
        this.mExtension = _measurementExtension = new MeasurementExtension();
        this.rExtension = _reportExtensions = new ReportExtensions();
    }

    @Override
    public String generate(ArrayList<ReportElement> reportElements) {
        String _xblockexpression = null;
        this.numberOfImages = this.numberOfImages;
        this.reportElements = reportElements;
        this.numberOfTestCases = this.mExtension.testCaseCount((Measurement)this.measurement).testCases;
        this.populateStatechartSet(this.measurement);
        this.avgTotalCoverage = this.coveragePercent(this.measurement);
        _xblockexpression = this.toHtml((Object[])Conversions.unwrapArray(this.testCases, Object.class)).toString();
        return _xblockexpression;
    }

    public CharSequence toHtml(Object[] testCases) {
        boolean _lessThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!DOCTYPE html>");
        _builder.newLine();
        _builder.append("<head>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<meta charset=\"UTF-8\" />");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"/>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"/>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script type=\"text/javascript\" src=\"./js/jquery-1.10.2.min.js\"></script>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script type=\"text/javascript\" src=\"./js/bootstrap.bundle.min.js\"></script>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<link rel=\"stylesheet\" href=\"./css/jquery.treegrid.css\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script type=\"text/javascript\" src=\"./js/jquery.treegrid.js\"></script>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<link rel=\"stylesheet\" href=\"./css/bootstrap.min.css\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<link rel=\"stylesheet\" href=\"./css/custom-styles.css\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script src=\"./js/stylesheetToggle.js\"></script>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<link id=\"stylesheet\" rel=\"stylesheet\" href=\"./css/custom-styles-color.css\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<title>Coverage Report</title>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<script>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("let currentStyle = \"color\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("var stylesheet = document.getElementById(\"stylesheet\")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("function toggleStylesheet() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("console.log(stylesheet)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("let progressBars = document.getElementsByClassName(\"progress-bar\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (currentStyle == \"color\") {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stylesheet.setAttribute(\"href\", \"./css/custom-styles-grey.css\")");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Array.from(progressBars).forEach(bar => bar.classList.replace(\"bg-success\", \"bg-secondary\"));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("currentStyle = \"grey\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else if (currentStyle == \"grey\") {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("stylesheet.href = \"./css/custom-styles-color.css\";");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("Array.from(progressBars).forEach(bar => bar.classList.replace(\"bg-secondary\", \"bg-success\"));");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("currentStyle = \"color\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</script>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("<body class=\"p-4 summary container mw-50\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<div class=\"d-flex flex-row justify-content-between align-middle\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<div class=\"d-flex align-items-center\">");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<p class=\"display-6 mb-0\">Statechart Test Coverage Report<br/>\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("for ");
        CharSequence _subjectType = this.subjectType(this.measurement.getSubject());
        _builder.append((Object)_subjectType, "\t\t\t");
        _builder.append(" '");
        String _subjectID = this.measurement.getSubjectID();
        _builder.append(_subjectID, "\t\t\t");
        _builder.append("'</p>\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</div>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<div id=\"logo\"></div>");
        _builder.newLine();
        _builder.append("\t\t\t    ");
        _builder.append("</div>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<span style=\"float: right; color: blue; text-decoration: underline;\" onclick=\"toggleStylesheet()\">Toggle Greyscale</span>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<div>");
        _builder.newLine();
        _builder.append("\t\t      ");
        _builder.append("<h2 class=\"pb-2\">Summary</h2>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t      ");
        _builder.append("<p>Report created: ");
        Date _date = new Date();
        _builder.append((Object)_date, "\t\t      ");
        _builder.append("</p>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t      ");
        _builder.append("<p>Coverage measured: ");
        long _timestamp = this.measurement.getTimestamp();
        Date _date_1 = new Date(_timestamp);
        _builder.append((Object)_date_1, "\t\t      ");
        _builder.append("</p>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t      ");
        _builder.append("<p>Total test cases: ");
        _builder.append((Object)this.numberOfTestCases, "\t\t      ");
        _builder.append("</p>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t      ");
        _builder.append("<div>");
        _builder.newLine();
        _builder.append("\t\t      \t");
        _builder.append("<p>Overall report coverage:</p>");
        _builder.newLine();
        _builder.append("\t\t      \t");
        _builder.append("<div class=\"progress w-25\">");
        _builder.newLine();
        _builder.append("\t\t      \t        ");
        _builder.append("<div class=\"progress-bar progress-bar-striped bg-success\" role=\"progressbar\" style=\"width: ");
        _builder.append((Object)this.avgTotalCoverage, "\t\t      \t        ");
        _builder.append("%\" aria-valuenow=\"50\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t      \t          ");
        _builder.append("aria-valuemin=\"0\" aria-valuemax=\"100\">");
        String _plainString = this.avgTotalCoverage.toPlainString();
        _builder.append(_plainString, "\t\t      \t          ");
        _builder.append("%</div>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t      \t      ");
        _builder.append("</div>");
        _builder.newLine();
        _builder.append("\t\t      ");
        _builder.append("</div>");
        _builder.newLine();
        _builder.append("\t\t      ");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("</div>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<br>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<p>A total of ");
        Object _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)IterableExtensions.toSet(this.statechartList), Object.class)).length;
        boolean bl = _lessThan = _length < 2;
        if (_lessThan) {
            _xifexpression = "1 statechart was";
        } else {
            int _length_1 = ((Object[])Conversions.unwrapArray((Object)IterableExtensions.toSet(this.statechartList), Object.class)).length;
            _xifexpression = String.valueOf((Object)_length_1) + " statecharts were";
        }
        _builder.append((String)_xifexpression, "\t\t  ");
        _builder.append(" tested:</p>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t  ");
        _builder.append("<br>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<br>");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("<div>");
        _builder.newLine();
        for (ReportElement reportElement : this.reportElements) {
            _builder.append("\t\t  \t");
            _builder.append("<h4>");
            String _name = reportElement.getMeasurement().getParent().getName();
            _builder.append(_name, "\t\t  \t");
            _builder.append(": ");
            String _name_1 = reportElement.getMeasurement().getName();
            _builder.append(_name_1, "\t\t  \t");
            _builder.append("</h4>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t  \t");
            EObject _subject = reportElement.getMeasurement().getSubject();
            String _statechartStatisticsToHtml = this.statechartStatisticsToHtml((Statechart)_subject, reportElement.getMeasurement(), testCases, this.statechartCounter);
            _builder.append(_statechartStatisticsToHtml, "\t\t  \t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t  \t");
            _builder.append("<table class=\"tree");
            _builder.append((Object)this.treeTableCounter, "\t\t  \t");
            _builder.append(" table\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t  \t");
            _builder.append("\t");
            String _htmlRows = this.toHtmlRows(reportElement.getMeasurement(), 0, true, this.idCounter);
            _builder.append(_htmlRows, "\t\t  \t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t  \t");
            _builder.append("\t");
            this.incrementTreeTableCounter();
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t  \t");
            _builder.append("</table>");
            _builder.newLine();
            _builder.append("\t\t  \t");
            CharSequence _outputImages = this.outputImages(reportElement);
            _builder.append((Object)_outputImages, "\t\t  \t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t  \t");
            _builder.append(" ");
            _builder.append("<br>");
            _builder.newLine();
            _builder.append("\t\t  \t");
            _builder.append(" ");
            _builder.append("<hr>");
            _builder.newLine();
            _builder.append("\t\t  \t");
            _builder.append(" ");
            _builder.append("<br>");
            _builder.newLine();
        }
        _builder.append("\t\t  ");
        _builder.append("</div>");
        _builder.newLine();
        String _generateTreegridScripts = this.generateTreegridScripts();
        _builder.append(_generateTreegridScripts);
        _builder.newLineIfNotEmpty();
        _builder.append("</body>");
        _builder.newLine();
        _builder.append("</html>");
        _builder.newLine();
        return _builder;
    }

    public String statechartStatisticsToHtml(Statechart it, Measurement measurement, Object testCases, int i) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<br>");
        _builder.newLine();
        _builder.append("<p>Number of States: ");
        int _length = ((Object[])Conversions.unwrapArray(this.getAllStates(it), Object.class)).length;
        _builder.append((Object)_length);
        _builder.append("</p>");
        _builder.newLineIfNotEmpty();
        _builder.append("<p>Number of Transitions: ");
        int _length_1 = ((Object[])Conversions.unwrapArray(this.getAllTransitions(it), Object.class)).length;
        _builder.append((Object)_length_1);
        _builder.append("</p>");
        _builder.newLineIfNotEmpty();
        _builder.append("<p>Overall statechart coverage: ");
        String _valueText = this.valueText(measurement);
        _builder.append(_valueText);
        _builder.append("</p>");
        _builder.newLineIfNotEmpty();
        String statistics = _builder.toString();
        ++this.statechartCounter;
        _xblockexpression = statistics;
        return _xblockexpression;
    }

    public String toHtmlRows(Measurement it, int i, boolean firstRow, int next) {
        ++this.idCounter;
        ++this.iconCounter;
        int tempCounter = this.idCounter;
        int percent = this.coveragePercent(it).intValue();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<tr style=\"margin-right:40px;\" class=\"treegrid-");
        _builder.append((Object)this.idCounter);
        _builder.append(" ");
        Object _xifexpression = null;
        _xifexpression = Boolean.valueOf(firstRow) == Boolean.valueOf(true) ? "" : "treegrid-parent-" + String.valueOf((Object)next);
        _builder.append((String)_xifexpression);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<td>");
        String _itemDescription = this.itemDescription(it);
        _builder.append(_itemDescription, "\t");
        _builder.append("</td>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<td style=\"width:25%\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<div class=\"progress\" style=\"width: 100%; float: right;\">");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("<div class=\"progress-bar progress-bar-striped bg-success\" role=\"progressbar\" style=\"width: ");
        _builder.append((Object)percent, "\t\t    ");
        _builder.append("%\" aria-valuenow=\"50\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t      ");
        _builder.append("aria-valuemin=\"0\" aria-valuemax=\"100\">");
        String _valueText = this.valueText(it);
        _builder.append(_valueText, "\t\t      ");
        _builder.append("</div>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t               ");
        _builder.append("<div class=\"progress-bar\" role=\"progressbar\" style=\"width:");
        _builder.append((Object)(100 - percent), "\t\t               ");
        _builder.append("%; ");
        String _xifexpression_1 = null;
        if (percent < 1) {
            _xifexpression_1 = "color:#000;";
        }
        _builder.append(_xifexpression_1, "\t\t               ");
        _builder.append("\" aria-valuenow=\"50\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t                 ");
        _builder.append("aria-valuemin=\"0\" aria-valuemax=\"100\">");
        String _xifexpression_2 = null;
        _xifexpression_2 = percent < 1 ? this.valueText(it) : "";
        _builder.append(_xifexpression_2, "\t\t                 ");
        _builder.append("</div>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t  ");
        _builder.append("</div>\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</td>");
        _builder.newLine();
        _builder.append("</tr>");
        _builder.newLine();
        boolean _hasChildren = it.hasChildren();
        if (_hasChildren) {
            List<Measurement> _filterChildren = this.filterChildren(it);
            for (Measurement child : _filterChildren) {
                _builder.append("\t");
                String _htmlRows = this.toHtmlRows(child, i + 1, false, tempCounter);
                _builder.append(_htmlRows, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder.toString();
    }

    public CharSequence outputImages(ReportElement reportElement) {
        StringConcatenation _builder = new StringConcatenation();
        int _size = reportElement.getImages().size();
        IntegerRange _upTo = new IntegerRange(0, _size);
        for (Integer i : _upTo) {
            _builder.append("<div>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("<img src=\"./img/");
            String _imageName = this.rExtension.imageName(reportElement, i);
            _builder.append(_imageName, "\t");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            _builder.append("</div>");
            _builder.newLine();
        }
        return _builder;
    }

    public String generateTreegridScripts() {
        StringConcatenation _builder = new StringConcatenation();
        int _length = ((Object[])Conversions.unwrapArray(this.statechartList, Object.class)).length;
        IntegerRange _upTo = new IntegerRange(0, _length);
        for (Integer i : _upTo) {
            _builder.append("<script type=\"text/javascript\">");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("$(document).ready(function () {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$('.tree");
            _builder.append((Object)i, "\t\t");
            _builder.append("').treegrid();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("});");
            _builder.newLine();
            _builder.append("</script>");
            _builder.newLine();
        }
        return _builder.toString();
    }

    public void incrementTreeTableCounter() {
        ++this.treeTableCounter;
    }

    public List<Measurement> filterChildren(Measurement it) {
        Functions.Function1 _function = it_1 -> it_1.getSubject() instanceof SCTUnitClass || it_1.getSubject() instanceof Property || it_1.getSubject() instanceof State || it_1.getSubject() instanceof Transition || it_1.getSubject() instanceof Statechart || it_1.getSubject() instanceof Region || it_1.getSubject() instanceof Choice || it_1.getSubject() instanceof FinalState || it_1.getSubject() instanceof Synchronization;
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)it.getChildren(), (Functions.Function1)_function));
    }

    protected EObject _element(Object it) {
        return null;
    }

    protected EObject _element(Measurement it) {
        return it.getSubject();
    }

    public BigDecimal coveragePercent(Measurement it) {
        BigDecimal _bigDecimal = new BigDecimal((double)this.mExtension.coverage((Measurement)it).coverage * 100.0);
        MathContext _mathContext = new MathContext(5, RoundingMode.HALF_UP);
        return _bigDecimal.round(_mathContext);
    }

    public String valueText(Measurement it) {
        String _xblockexpression = null;
        Measurement.StateTransitionCoverage cov = this.mExtension.coverage(it);
        String _plainString = this.coveragePercent(it).toPlainString();
        String _plus = _plainString + "% (";
        String _plus_1 = _plus + String.valueOf((Object)cov.weight);
        _xblockexpression = _plus_1 + ")";
        return _xblockexpression;
    }

    public String itemDescription(Object it) {
        return this.labelProvider.getText(it);
    }

    public List<Transition> getAllTransitions(Statechart statechart) {
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)statechart.eAllContents(), Transition.class));
    }

    public List<State> getAllStates(Statechart statechart) {
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)statechart.eAllContents(), State.class));
    }

    public void populateStatechartSet(Measurement measurement) {
        List _children;
        boolean _tripleNotEquals;
        if (measurement == null) {
            return;
        }
        EObject _subject = measurement.getSubject();
        if (_subject instanceof Statechart) {
            EObject _subject_1 = measurement.getSubject();
            this.statechartList.add((Statechart)_subject_1);
        }
        boolean bl = _tripleNotEquals = (_children = measurement.getChildren()) != null;
        if (_tripleNotEquals) {
            List _children_1 = measurement.getChildren();
            for (Measurement child : _children_1) {
                this.populateStatechartSet(child);
            }
        }
    }

    protected CharSequence _subjectType(SCTUnitClass it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Test Class");
        return _builder;
    }

    protected CharSequence _subjectType(SCTUnitSuite it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Test Suite");
        return _builder;
    }

    protected CharSequence _subjectType(EObject it) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = it.eClass().getName();
        _builder.append(_name);
        return _builder;
    }

    protected CharSequence _subjectType(Object it) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = it.getClass().getSimpleName();
        _builder.append(_simpleName);
        return _builder;
    }

    protected CharSequence _subjectType(Void it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @XbaseGenerated
    public EObject element(Object it) {
        if (it instanceof Measurement) {
            return this._element((Measurement)it);
        }
        if (it != null) {
            return this._element(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence subjectType(Object it) {
        if (it instanceof SCTUnitClass) {
            return this._subjectType((SCTUnitClass)it);
        }
        if (it instanceof SCTUnitSuite) {
            return this._subjectType((SCTUnitSuite)it);
        }
        if (it instanceof EObject) {
            return this._subjectType((EObject)it);
        }
        if (it == null) {
            return this._subjectType((Void)null);
        }
        return this._subjectType(it);
    }
}

