/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.ui.simulation;

import com.google.inject.Inject;
import com.yakindu.base.expressions.interpreter.AbstractOperationExecutor;
import com.yakindu.sct.commons.WorkspaceClassLoaderFactory;
import com.yakindu.sct.domain.java.resource.ClassLoaderProvider;
import com.yakindu.sct.domain.java.resource.JavaFileLocationAdapter;
import com.yakindu.sct.domain.java.resource.JavaResource;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.util.ReflectionUtil;

public abstract class AbstractJavaExecutor
extends AbstractOperationExecutor {
    @Inject
    protected IQualifiedNameProvider nameProvider;
    @Inject
    protected WorkspaceClassLoaderFactory factory;
    @Inject
    protected ClassLoaderProvider classLoaders;

    protected Class<?> loadClass(EObject owner) {
        ClassLoader classLoader = this.classLoaders.get((JavaResource)owner.eResource());
        try {
            Optional<JavaFileLocationAdapter> adapterOpt = owner.eAdapters().stream().filter(JavaFileLocationAdapter.class::isInstance).map(JavaFileLocationAdapter.class::cast).findFirst();
            JavaFileLocationAdapter adapter = adapterOpt.orElseThrow(() -> new IllegalStateException("No JavaFileLocationAdapter found on owner."));
            String location = adapter.getName();
            if (location == null || location.trim().isEmpty()) {
                throw new IllegalStateException("Adapter returned null or empty class name.");
            }
            try {
                return classLoader.loadClass(location);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not load class: " + location, e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object[] castIfNecessary(Object[] arguments, Class<?>[] argumentTypes) {
        if (arguments.length != argumentTypes.length) {
            throw new IllegalArgumentException("Arguments and types length mismatch");
        }
        Object[] converted = new Object[arguments.length];
        int i = 0;
        while (i < argumentTypes.length) {
            Object arg = arguments[i];
            Class<?> targetType = argumentTypes[i];
            if (arg == null) {
                converted[i] = null;
            } else {
                Class<?> argType = arg.getClass();
                if (ReflectionUtil.getObjectType(targetType).isAssignableFrom(argType)) {
                    converted[i] = arg;
                } else {
                    if (!(arg instanceof Number)) throw new IllegalArgumentException("Cannot convert type " + argType.getName() + " to " + targetType.getName());
                    Number number = (Number)arg;
                    if (targetType == Long.class || targetType == Long.TYPE) {
                        converted[i] = number.longValue();
                    } else if (targetType == Integer.class || targetType == Integer.TYPE) {
                        converted[i] = number.intValue();
                    } else if (targetType == Double.class || targetType == Double.TYPE) {
                        converted[i] = number.doubleValue();
                    } else if (targetType == Float.class || targetType == Float.TYPE) {
                        converted[i] = Float.valueOf(number.floatValue());
                    } else if (targetType == Short.class || targetType == Short.TYPE) {
                        converted[i] = number.shortValue();
                    } else {
                        if (targetType != Byte.class && targetType != Byte.TYPE) throw new IllegalArgumentException("Cannot convert Number to " + targetType.getName());
                        converted[i] = number.byteValue();
                    }
                }
            }
            ++i;
        }
        return converted;
    }
}

