/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.domain.java.ui.simulation;

import com.google.common.collect.Lists;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.Operation;
import com.yakindu.sct.domain.java.ui.simulation.AbstractJavaExecutor;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.ReflectionUtil;

public class StaticOperationExecutor
extends AbstractJavaExecutor {
    public boolean canExecute(ArgumentExpression expression, ExecutionContext context) {
        EObject owner = this.getOwner(expression);
        if (owner instanceof VariableDefinition && (EcoreUtil2.getContainerOfType((EObject)owner, Statechart.class) != null || EcoreUtil2.getContainerOfType((EObject)owner, ExecutionFlow.class) != null)) {
            return false;
        }
        Operation operation = this.getOperation(expression);
        return operation.isStatic() && owner instanceof ComplexType;
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context) {
        return this.execute(expression, context, null);
    }

    public Object execute(ArgumentExpression expression, ExecutionContext context, List<Object> argValues) {
        Operation operation = this.getOperation(expression);
        EObject owner = this.getOwner(expression);
        try {
            Class<?> clazz = this.loadClass(owner);
            Object[] arguments = this.provideArguments(argValues, (List)expression.getArguments(), context, operation);
            List<Class<?>> argumentTypes = Arrays.stream(arguments).map(p -> p.getClass()).collect(Collectors.toList());
            if (operation.getName().equals("new")) {
                return this.createNewInstance(clazz, arguments, argumentTypes);
            }
            return this.callMethod(operation, clazz, arguments, argumentTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object callMethod(Operation operation, Class<?> clazz, Object[] arguments, List<Class<?>> argumentTypes) throws IllegalAccessException, InvocationTargetException {
        ArrayList result = Lists.newArrayList();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && method.getName().equals(operation.getName()) && this.isInvokeable(method, argumentTypes)) {
                result.add(method);
            }
            ++n2;
        }
        if (result.size() > 1) {
            return this.handleAmbigousMethods(clazz, operation.getName(), argumentTypes);
        }
        if (result.isEmpty()) {
            return this.handleNoSuchMethod(clazz, operation.getName(), argumentTypes);
        }
        return ((Method)result.get(0)).invoke(null, arguments);
    }

    protected Object createNewInstance(Class<?> clazz, Object[] arguments, List<Class<?>> argumentTypes) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors;
        Constructor<?>[] constructorArray = constructors = clazz.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (Modifier.isPublic(constructor.getModifiers()) && this.isInvokeable(constructor, argumentTypes)) {
                return constructor.newInstance(super.castIfNecessary(arguments, constructor.getParameterTypes()));
            }
            ++n2;
        }
        return null;
    }

    protected Object handleNoSuchMethod(Class<?> ownerClazz, String name, List<Class<?>> argumentTypes) {
        throw new IllegalStateException("Could not find public static method '" + name + "' in class '" + ownerClazz.getSimpleName() + "' for arguments " + String.valueOf(argumentTypes));
    }

    protected Object handleAmbigousMethods(Class<?> ownerClazz, String name, List<Class<?>> argumentTypes) {
        throw new IllegalStateException("Found multiple public static methods '" + name + "' in class '" + ownerClazz.getSimpleName() + "' for arguments " + String.valueOf(argumentTypes));
    }

    protected boolean isInvokeable(Executable method, List<Class<?>> argumentTypes) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != argumentTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < argumentTypes.size()) {
            Class<?> argTypeClass = argumentTypes.get(i);
            Class paramType = ReflectionUtil.getObjectType(parameterTypes[i]);
            Class argType = ReflectionUtil.getObjectType(argTypeClass);
            if (argTypeClass != null && !Void.class.equals(argTypeClass) && !this.paramAndArgTypeCompatible(paramType, argType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean paramAndArgTypeCompatible(Class<?> paramType, Class<?> argType) {
        if (paramType == Long.class || paramType == Integer.class) {
            return argType == Long.class || argType == Integer.class;
        }
        return !ReflectionUtil.getObjectType(paramType).isAssignableFrom(argType);
    }
}

