/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.coverage;

import com.yakindu.sct.simulation.core.coverage.MeasureCalculator;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.ui.coverage.CoverageResultView;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class SimulationPartListener
implements IPartListener {
    Consumer<Measurement> onInputChanged;
    MeasureCalculator measureCalculator = new MeasureCalculator();

    public SimulationPartListener(Consumer<Measurement> onInputChanged) {
        this.onInputChanged = onInputChanged;
    }

    public void partOpened(IWorkbenchPart part) {
        this.measurementCallback(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
        this.measurementCallback(part);
    }

    private void measurementCallback(IWorkbenchPart part) {
        SCTDebugTarget target;
        if (part instanceof CoverageResultView && (target = this.getActiveTarget()) != null) {
            Measurement m = target.getMeasurement();
            this.measureCalculator.defineCoverage(m);
            this.onInputChanged.accept(m);
        }
    }

    private SCTDebugTarget getActiveTarget() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        List<ILaunch> launches = Arrays.asList(launchManager.getLaunches());
        return launches.stream().map(l -> l.getDebugTarget()).filter(t -> t instanceof SCTDebugTarget).map(t -> (SCTDebugTarget)t).findFirst().orElseGet(() -> null);
    }
}

