/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.AnnotatableElement;
import com.yakindu.base.types.annotations.VisibilityAnnotations;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.java.GeneratorPredicate;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.JavaIncludeProvider;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.generator.java.features.OutEventObservables;
import com.yakindu.sct.generator.java.submodules.EventCode;
import com.yakindu.sct.generator.java.submodules.FieldDeclarationGenerator;
import com.yakindu.sct.generator.java.submodules.InterfaceFunctionsGenerator;
import com.yakindu.sct.generator.java.submodules.InternalFunctionsGenerator;
import com.yakindu.sct.generator.java.submodules.InternalTypes;
import com.yakindu.sct.generator.java.submodules.MethodGenerator;
import com.yakindu.sct.generator.java.submodules.StatemachineFunctionsGenerator;
import com.yakindu.sct.generator.java.submodules.TimingFunctions;
import com.yakindu.sct.generator.java.submodules.eventdriven.RunnableExtension;
import com.yakindu.sct.generator.java.submodules.lifecycle.IsActive;
import com.yakindu.sct.generator.java.submodules.lifecycle.IsFinal;
import com.yakindu.sct.generator.java.submodules.lifecycle.IsStateActive;
import com.yakindu.sct.generator.java.templates.ClassTemplate;
import com.yakindu.sct.generator.java.templates.FileTemplate;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.concepts.EventQueue;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions;
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Statemachine {
    @Inject
    @Extension
    protected EventQueue _eventQueue;
    @Inject
    private Set<JavaIncludeProvider> includeProviders;
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    private StringHelper _stringHelper;
    @Inject
    @Extension
    private EventCode _eventCode;
    @Inject
    @Extension
    private InterfaceFunctionsGenerator _interfaceFunctionsGenerator;
    @Inject
    @Extension
    private InternalFunctionsGenerator _internalFunctionsGenerator;
    @Inject
    @Extension
    private StatemachineFunctionsGenerator _statemachineFunctionsGenerator;
    @Inject
    @Extension
    private FieldDeclarationGenerator _fieldDeclarationGenerator;
    @Inject
    @Extension
    private TimingFunctions _timingFunctions;
    @Inject
    @Extension
    private IsActive _isActive;
    @Inject
    @Extension
    private IsStateActive _isStateActive;
    @Inject
    @Extension
    private IsFinal _isFinal;
    @Inject
    @Extension
    private RunnableExtension _runnableExtension;
    @Inject
    @Extension
    private MethodGenerator _methodGenerator;
    @Inject
    @Extension
    private VisibilityAnnotations _visibilityAnnotations;
    @Inject
    @Extension
    private GeneratorPredicate _generatorPredicate;
    @Inject
    @Extension
    private ShadowEventExtensions _shadowEventExtensions;
    @Inject
    @Extension
    private OutEventObservables _outEventObservables;
    @Inject
    @Extension
    private InternalTypes _internalTypes;
    @Inject
    @Extension
    private IFlowConfiguration _iFlowConfiguration;
    protected ExecutionFlow flow;
    protected GeneratorEntry entry;

    public void generateStatemachine(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        this.flow = flow;
        this.entry = entry;
        String _path = this._stringHelper.toPath(this._genmodelEntries.getBasePackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.statemachineClassName((NamedElement)flow));
        String filename = _plus + _java;
        fsa.generateFile(filename, this.content());
    }

    protected CharSequence content() {
        FileTemplate _packageName = FileTemplate.create().fileComment(this._genmodelEntries.getLicenseText(this.entry)).packageName(this._genmodelEntries.getBasePackage(this.entry));
        String _dot = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.iCycleBased());
        FileTemplate _addImport = _packageName.addImport(_dot, this._iFlowConfiguration.isCycleBased() && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        String _dot_1 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.iEventDriven());
        FileTemplate _addImport_1 = _addImport.addImport(_dot_1, this._eventQueue.isEventDriven(this.flow) && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        String _dot_2 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.iStatemachine());
        boolean _isEmpty = this._genmodelEntries.getLibraryPackage(this.entry).isEmpty();
        boolean _not = !_isEmpty;
        FileTemplate _addImport_2 = _addImport_1.addImport(_dot_2, _not);
        String _dot_3 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.iTimed());
        FileTemplate _addImport_3 = _addImport_2.addImport(_dot_3, this._sExecExtensions.isTimed(this.flow) && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        String _dot_4 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.iTimerService());
        FileTemplate _addImport_4 = _addImport_3.addImport(_dot_4, this._sExecExtensions.isTimed(this.flow) && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        String _dot_5 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.tracingListener());
        FileTemplate _addImport_5 = _addImport_4.addImport(_dot_5, this._genmodelEntries.tracingUsed(this.entry) && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        String _dot_6 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.traceEventClass());
        FileTemplate _addImport_6 = _addImport_5.addImport(_dot_6, this._genmodelEntries.tracingGeneric(this.entry) && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        String _dot_7 = this._stringHelper.dot(this._genmodelEntries.getLibraryPackage(this.entry), this._naming.traceEventTypeEnum());
        FileTemplate _addImport_7 = _addImport_6.addImport(_dot_7, this._genmodelEntries.tracingGeneric(this.entry) && !this._genmodelEntries.getLibraryPackage(this.entry).isEmpty());
        FileTemplate _addImport_8 = _addImport_7.addImport("java.util.LinkedList", this._eventQueue.requiresEventQueue(this.flow) && !this._generatorPredicate.needsSynchronized());
        FileTemplate _addImport_9 = _addImport_8.addImport("java.util.Queue", this._eventQueue.requiresEventQueue(this.flow) && !this._generatorPredicate.needsSynchronized());
        FileTemplate _addImport_10 = _addImport_9.addImport("java.util.concurrent.BlockingQueue", this._eventQueue.requiresEventQueue(this.flow) && this._generatorPredicate.needsSynchronized());
        FileTemplate _addImport_11 = _addImport_10.addImport("java.util.concurrent.LinkedBlockingQueue", this._eventQueue.requiresEventQueue(this.flow) && this._generatorPredicate.needsSynchronized());
        String _dot_8 = this._stringHelper.dot(this._outEventObservables.rxPackage(this.entry), this._outEventObservables.observableClass());
        FileTemplate _addImport_12 = _addImport_11.addImport(_dot_8, this._generatorPredicate.useOutEventObservables() && this._sExecExtensions.hasOutgoingEvents(this.flow) || this._genmodelEntries.tracingGeneric(this.entry));
        String _dot_9 = this._stringHelper.dot(this._outEventObservables.rxPackage(this.entry), this._outEventObservables.observerClass());
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)this._shadowEventExtensions.getShadowEvents(this.flow));
        boolean _not_1 = !_isNullOrEmpty;
        Functions.Function1 _function = it -> it.getImports(this.flow, this.entry);
        return _addImport_12.addImport(_dot_9, _not_1).addImport("java.util.LinkedList", this._genmodelEntries.tracingUsed(this.entry)).addImport("java.util.List", this._genmodelEntries.tracingUsed(this.entry)).addImports(Iterables.concat((Iterable)IterableExtensions.map(this.includeProviders, (Functions.Function1)_function))).classTemplate(this.classTemplate()).generate();
    }

    protected ClassTemplate classTemplate() {
        boolean _isCycleBased;
        ClassTemplate _xblockexpression = null;
        ClassTemplate cT = ClassTemplate.create().className(this._naming.statemachineClassName((NamedElement)this.flow)).classContent(this.classContent());
        boolean _isTimed = this._sExecExtensions.isTimed(this.flow);
        if (_isTimed) {
            cT.addInterface(this._naming.iTimed());
        }
        if (_isCycleBased = this._iFlowConfiguration.isCycleBased()) {
            cT.addInterface(this._naming.iCycleBased());
        } else {
            cT.addInterface(this._naming.iEventDriven());
        }
        boolean _needsRunnable = this._generatorPredicate.needsRunnable();
        if (_needsRunnable) {
            cT.addInterface("Runnable");
        }
        _xblockexpression = cT;
        return _xblockexpression;
    }

    protected CharSequence classContent() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _needsRunnable = this._generatorPredicate.needsRunnable();
        if (_needsRunnable) {
            _builder.newLine();
            CharSequence _runnable = this._runnableExtension.runnable(this.flow);
            _builder.append((Object)_runnable);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        CharSequence _interfaceClasses = this._interfaceFunctionsGenerator.interfaceClasses(this.flow, this.entry);
        _builder.append((Object)_interfaceClasses);
        _builder.newLineIfNotEmpty();
        String _internalTypes = this._internalTypes.internalTypes(this.flow);
        _builder.append(_internalTypes);
        _builder.newLineIfNotEmpty();
        CharSequence _createFieldDeclarations = this._fieldDeclarationGenerator.createFieldDeclarations(this.flow, this.entry);
        _builder.append((Object)_createFieldDeclarations);
        _builder.newLineIfNotEmpty();
        CharSequence _createConstructor = this._statemachineFunctionsGenerator.createConstructor(this.flow, this.entry);
        _builder.append((Object)_createConstructor);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = it -> this._visibilityAnnotations.isPublic((AnnotatableElement)it);
        CharSequence _implementation = this._methodGenerator.toImplementation(IterableExtensions.filter((Iterable)this._sExecExtensions.methods(this.flow), (Functions.Function1)_function));
        _builder.append((Object)_implementation);
        _builder.newLineIfNotEmpty();
        CharSequence _isActive = this._isActive.isActive(this.flow);
        _builder.append((Object)_isActive);
        _builder.newLineIfNotEmpty();
        CharSequence _isFinal = this._isFinal.isFinal(this.flow);
        _builder.append((Object)_isFinal);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_1 = it -> {
            boolean _isPublic = this._visibilityAnnotations.isPublic((AnnotatableElement)it);
            return !_isPublic;
        };
        CharSequence _implementation_1 = this._methodGenerator.toImplementation(IterableExtensions.filter((Iterable)this._sExecExtensions.methods(this.flow), (Functions.Function1)_function_1));
        _builder.append((Object)_implementation_1);
        _builder.newLineIfNotEmpty();
        Object _nextEvent = this._eventCode.nextEvent(this.flow);
        _builder.append(_nextEvent);
        _builder.newLineIfNotEmpty();
        CharSequence _isStateActive = this._isStateActive.isStateActive(this.flow);
        _builder.append((Object)_isStateActive);
        _builder.newLineIfNotEmpty();
        CharSequence _timingFunctions = this._timingFunctions.timingFunctions(this.flow);
        _builder.append((Object)_timingFunctions);
        _builder.newLineIfNotEmpty();
        CharSequence _interfaceAccessors = this._statemachineFunctionsGenerator.interfaceAccessors(this.flow, this.entry);
        _builder.append((Object)_interfaceAccessors);
        _builder.newLineIfNotEmpty();
        CharSequence _internalScopeFunctions = this._internalFunctionsGenerator.internalScopeFunctions(this.flow);
        _builder.append((Object)_internalScopeFunctions);
        _builder.newLineIfNotEmpty();
        CharSequence _defaultInterfaceFunctions = this._statemachineFunctionsGenerator.defaultInterfaceFunctions(this.flow, this.entry);
        _builder.append((Object)_defaultInterfaceFunctions);
        _builder.newLineIfNotEmpty();
        CharSequence _functionImplementations = this._internalFunctionsGenerator.functionImplementations(this.flow);
        _builder.append((Object)_functionImplementations);
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

