/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.preferences;

import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.LicenseManagementActivator;
import com.yakindu.licmgmt.internal.preferences.ILicensePreferences;
import com.yakindu.licmgmt.internal.preferences.LicensePreferences;
import com.yakindu.licmgmt.internal.utils.SerializeUtils;
import java.util.Map;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class LicensePreferencesInitializer
extends AbstractPreferenceInitializer
implements ILicensePreferences {
    public void initializeDefaultPreferences() {
        this.initLicenseServerPreferences();
        this.migrateOldSettingsIfNeeded();
    }

    private void initLicenseServerPreferences() {
        ServerSettings extServerSettings = ILicenseService.INSTANCE.getServerSettings();
        if (extServerSettings != null && extServerSettings != ServerSettings.NOT_AVAILABLE) {
            LicensePreferences.setLicenseServerDefault(extServerSettings);
        } else {
            LicensePreferences.setLicenseServerDefault(ServerSettings.createFrom((String)"%6200", (boolean)false, (boolean)false));
        }
    }

    private void migrateOldSettingsIfNeeded() {
        IEclipsePreferences instancePrefNode = LicensePreferences.getInstancePreferenceNode();
        boolean serverMigrated = this.migrateLicenseServerIfNeeded(instancePrefNode);
        boolean enabledMigrated = LicensePreferencesInitializer.migrateSerializedSettingsIfNeeded(instancePrefNode, "licenseDisabled", "licenseEnabled_", true);
        boolean notificationsMigrated = LicensePreferencesInitializer.migrateSerializedSettingsIfNeeded(instancePrefNode, "licenseNotification", "licenseNotification_", PREF_KEY_LICENSE_NOTIFICATION_DEFAULT);
        if (serverMigrated || enabledMigrated || notificationsMigrated) {
            try {
                instancePrefNode.flush();
            }
            catch (BackingStoreException e) {
                LicenseManagementActivator.logErrorMessage("Failed to migrate old preference settings: " + e.getMessage());
            }
        }
    }

    private boolean migrateLicenseServerIfNeeded(IEclipsePreferences instancePrefNode) {
        String oldAddress = instancePrefNode.get("floatingLicenseServerAddress", null);
        String oldPort = instancePrefNode.get("floatingLicenseServerPort", null);
        if (oldAddress != null || oldPort != null) {
            String newAddress = oldAddress == null || oldAddress.trim().isEmpty() ? "" : oldAddress.trim();
            String newPort = oldPort == null || oldPort.trim().isEmpty() ? "6200" : oldPort.trim();
            int newEnabled = oldAddress != null && !oldAddress.trim().isEmpty() ? 1 : 0;
            String newValue = String.format("%d:%s@%s", newEnabled, newAddress, newPort);
            instancePrefNode.put("floatingLicenseServer", newValue);
            instancePrefNode.remove("floatingLicenseServerAddress");
            instancePrefNode.remove("floatingLicenseServerPort");
            return true;
        }
        return false;
    }

    private static boolean migrateSerializedSettingsIfNeeded(IEclipsePreferences instancePrefNode, String deprecatedPrefKey, String prefKeyPrefix, boolean defaultValue) {
        String oldValue = instancePrefNode.get(deprecatedPrefKey, null);
        if (oldValue != null) {
            Map<String, Boolean> map;
            if (!oldValue.trim().isEmpty() && (map = SerializeUtils.deserialize(oldValue, defaultValue)) != null && !map.isEmpty()) {
                for (String licenseFeatureId : map.keySet()) {
                    Boolean value = map.get(licenseFeatureId);
                    if (value == null) continue;
                    instancePrefNode.putBoolean(String.valueOf(prefKeyPrefix) + licenseFeatureId, value.booleanValue());
                }
            }
            instancePrefNode.remove(deprecatedPrefKey);
            return true;
        }
        return false;
    }
}

