/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.preferences;

import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.EclipseLicenseService;
import com.yakindu.licmgmt.internal.EclipseLicenseSettings;
import com.yakindu.licmgmt.internal.preferences.ILicensePreferences;
import com.yakindu.licmgmt.internal.preferences.LicensePreferences;
import com.yakindu.licmgmt.ui.internal.model.LicenseTableModel;
import com.yakindu.licmgmt.ui.internal.preferences.LicenseTableFieldEditor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LicensePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
ILicensePreferences {
    public static final String PREF_PAGE_ID = "com.yakindu.licmgmt.ui.preferences.page";
    private static final String RESTART_REQUIRED_MESSAGE = "Please restart the application to apply your changes.";
    private static final String INVALID_SERVER_PORT_NUMBER_MESSAGE = "The port number must be a number value between 1024 and 65535.";
    private static final String EMPTY_SERVER_ADDRESS_MESSAGE = "The server address must not be empty. Please enter a valid name.";
    private static final String EXTERNAL_SERVER_CONFIGURATION_MESSAGE = "The configuration data of the license server were defined outside the application and cannot be changed here.";
    private static final String CONTEXT_HELP_ID = "com.yakindu.licmgmt.doc.contextLicenseConfiguration";
    private LicenseTableFieldEditor licenseTableEditor;
    private Button enableLicenseServerSettings;
    private Group licenseServerGroup;
    private Label serverAddressLabel;
    private Label serverPortLabel;
    private Text serverAddressText;
    private Text serverPortText;
    private ServerSettings currentServerSettings;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        Composite composite = this.createLicenseServerGroup(parent);
        return super.createContents(composite);
    }

    protected void createFieldEditors() {
        this.licenseTableEditor = new LicenseTableFieldEditor(this.getFieldEditorParent());
        this.addField(this.licenseTableEditor);
        this.setRestartMessageIfSettingsChanged();
        this.updateButtons();
        this.getFieldEditorParent().pack(true);
    }

    private Composite createLicenseServerGroup(Composite parent) {
        this.enableLicenseServerSettings = new Button(parent, 32);
        this.enableLicenseServerSettings.setText("Enable license server");
        this.enableLicenseServerSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.updateServerSettingsGroup(LicensePreferencePage.this.enableLicenseServerSettings.getSelection());
                LicensePreferencePage.this.updateButtons();
            }
        });
        ServerSettings savedLicServer = LicensePreferences.getLicenseServer();
        this.enableLicenseServerSettings.setSelection(savedLicServer.isEnabled());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.licenseServerGroup = new Group(composite, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.marginWidth = 6;
        groupLayout.marginHeight = 6;
        this.licenseServerGroup.setLayout((Layout)groupLayout);
        GridData groupLayoutData = new GridData();
        groupLayoutData.horizontalAlignment = 4;
        groupLayoutData.grabExcessHorizontalSpace = true;
        this.licenseServerGroup.setLayoutData((Object)groupLayoutData);
        GridData serverTextLayoutData = new GridData();
        serverTextLayoutData.horizontalAlignment = 4;
        serverTextLayoutData.grabExcessHorizontalSpace = true;
        this.serverAddressLabel = new Label((Composite)this.licenseServerGroup, 0);
        this.serverAddressLabel.setText("Server Address (URL):");
        this.serverAddressText = new Text((Composite)this.licenseServerGroup, 2052);
        this.serverAddressText.setLayoutData((Object)serverTextLayoutData);
        this.serverPortLabel = new Label((Composite)this.licenseServerGroup, 0);
        this.serverPortLabel.setText("Port:");
        this.serverPortText = new Text((Composite)this.licenseServerGroup, 2052);
        this.serverPortText.setLayoutData((Object)serverTextLayoutData);
        if (this.currentServerSettings.isExternal()) {
            this.enableLicenseServerSettings.setSelection(true);
            this.enableLicenseServerSettings.setEnabled(false);
            this.serverAddressText.setText(this.currentServerSettings.getHost() == null ? "" : this.currentServerSettings.getHost());
            this.serverPortText.setText(this.currentServerSettings.getPort() == null ? "" : this.currentServerSettings.getPort());
            parent.setToolTipText(EXTERNAL_SERVER_CONFIGURATION_MESSAGE);
            composite.setToolTipText(EXTERNAL_SERVER_CONFIGURATION_MESSAGE);
            this.licenseServerGroup.setToolTipText(EXTERNAL_SERVER_CONFIGURATION_MESSAGE);
        } else {
            this.serverAddressText.setText(savedLicServer.getHost() == null ? "" : savedLicServer.getHost());
            this.serverAddressText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LicensePreferencePage.this.updateButtons();
                }
            });
            this.serverPortText.setText(savedLicServer.getPort() == null ? "" : savedLicServer.getPort());
            this.serverPortText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LicensePreferencePage.this.updateButtons();
                }
            });
        }
        this.updateServerSettingsGroup(savedLicServer.isEnabled() && !this.currentServerSettings.isExternal());
        return composite;
    }

    private void updateServerSettingsGroup(boolean isEnabled) {
        this.licenseServerGroup.setEnabled(isEnabled);
        this.serverAddressText.setEnabled(isEnabled);
        this.serverPortText.setEnabled(isEnabled);
        this.serverAddressLabel.setEnabled(isEnabled);
        this.serverPortLabel.setEnabled(isEnabled);
        this.checkValues();
    }

    private void updateButtons() {
        this.updateApplyButton();
        this.getContainer().updateButtons();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.yakindu.licmgmt.eclipse");
    }

    public void init(IWorkbench workbench) {
        this.currentServerSettings = IEclipseLicenseService.INSTANCE.getServerSettings();
    }

    protected void performDefaults() {
        ServerSettings currentServerSettings = IEclipseLicenseService.INSTANCE.getServerSettings();
        if (!currentServerSettings.isExternal()) {
            ServerSettings defaultLicenseServer = LicensePreferences.getLicenseServerDefault();
            this.enableLicenseServerSettings.setSelection(defaultLicenseServer.isEnabled());
            this.serverAddressText.setText(defaultLicenseServer.getHost());
            this.serverPortText.setText(defaultLicenseServer.getPort());
            this.updateServerSettingsGroup(defaultLicenseServer.isEnabled());
        }
        super.performDefaults();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            this.updateButtons();
        }
    }

    public boolean isValid() {
        return this.checkValues();
    }

    private boolean hasChangedValues() {
        boolean changed = this.enableLicenseServerSettings.getSelection() ^ LicensePreferences.getLicenseServer().isEnabled();
        changed |= !this.serverAddressText.getText().trim().equals(LicensePreferences.getLicenseServer().getHost());
        changed |= !this.serverPortText.getText().trim().equals(LicensePreferences.getLicenseServer().getPort());
        return changed |= this.licenseTableEditor.hasChangedEnableStates();
    }

    private boolean checkValues() {
        boolean valid = true;
        this.setErrorMessage(null);
        if (this.enableLicenseServerSettings != null && this.enableLicenseServerSettings.getSelection()) {
            String serverAddress;
            StringBuilder errorMessage = new StringBuilder();
            try {
                int port = Integer.parseInt(this.serverPortText.getText());
                if (port < 1024 || port > 65535) {
                    errorMessage.append(INVALID_SERVER_PORT_NUMBER_MESSAGE).append(" ");
                    valid = false;
                }
            }
            catch (NumberFormatException nfe) {
                errorMessage.append(INVALID_SERVER_PORT_NUMBER_MESSAGE).append(" ");
                valid = false;
            }
            if ((serverAddress = this.serverAddressText.getText()) == null || serverAddress.isEmpty()) {
                errorMessage.append(EMPTY_SERVER_ADDRESS_MESSAGE).append(" ");
                valid = false;
            }
            if (!valid) {
                this.setErrorMessage(errorMessage.toString());
            }
        }
        this.setValid(valid);
        return valid;
    }

    public void dispose() {
        LicenseTableModel.getInstance().clearModel();
    }

    public boolean performOk() {
        boolean updateModelRequired = this.hasChangedValues();
        if (this.isValid() && updateModelRequired) {
            String serverAddress = this.serverAddressText.getText().trim();
            String serverPort = this.serverPortText.getText().trim();
            boolean isServerEnabled = this.enableLicenseServerSettings.getSelection();
            boolean wasRestartRequiredForChangedSettings = this.isRestartRequiredForChangedSettings();
            LicensePreferences.setLicenseServer((ServerSettings)ServerSettings.createFrom((String)(String.valueOf(serverAddress) + "%" + serverPort), (boolean)isServerEnabled, (boolean)false));
            super.performOk();
            this.setRestartMessageIfSettingsChanged();
            if (!wasRestartRequiredForChangedSettings && this.isRestartRequiredForChangedSettings()) {
                String[] buttonLabels = new String[]{"Restart now", "Restart later"};
                MessageDialog dialog = new MessageDialog(this.getShell(), "Restart required", null, RESTART_REQUIRED_MESSAGE, 6, buttonLabels, 0);
                if (dialog.open() == 0) {
                    PlatformUI.getWorkbench().restart();
                    return true;
                }
            }
        }
        this.updateApplyButton();
        if (updateModelRequired) {
            LicenseTableModel.getInstance().updateModel(this.getShell());
        }
        return true;
    }

    private void setRestartMessageIfSettingsChanged() {
        if (this.isRestartRequiredForChangedSettings()) {
            this.setMessage(RESTART_REQUIRED_MESSAGE, 2);
        } else if (this.getMessage() != null) {
            this.setMessage("");
        }
    }

    private boolean isRestartRequiredForChangedSettings() {
        return ((EclipseLicenseSettings)((EclipseLicenseService)IEclipseLicenseService.INSTANCE).getSettings()).isRestartRequiredForChangedSettings();
    }
}

