/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.utils;

import com.yakindu.licmgmt.ServerSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PathUtils {
    public static final Boolean IGNORE_DEFAULT_PATHS = Boolean.FALSE;
    public static final String USER_HOME_YAKINDU_FOLDER = ".YAKINDU";

    public static List<String> getDefaultPaths() {
        if (IGNORE_DEFAULT_PATHS.booleanValue()) {
            return Collections.emptyList();
        }
        String cwdPath = PathUtils.getCurrentWorkingDirectoryPath();
        String userHomePath = PathUtils.getUserHomePath();
        ArrayList<String> list = new ArrayList<String>(4);
        if (cwdPath != null) {
            list.add(cwdPath);
        }
        if (userHomePath != null && !userHomePath.equals(cwdPath)) {
            list.add(userHomePath);
        }
        return list;
    }

    public static String getCurrentWorkingDirectoryPath() {
        String path = new File("").getAbsolutePath();
        if (path != null && !path.isEmpty() && path.endsWith(File.separator)) {
            return path.substring(0, path.length() - File.separator.length());
        }
        return path;
    }

    public static String getUserHomePath() {
        String userHomePath = System.getProperty("user.home");
        if (userHomePath == null || userHomePath.isEmpty()) {
            return null;
        }
        if (userHomePath.endsWith(File.separator)) {
            return String.valueOf(userHomePath) + USER_HOME_YAKINDU_FOLDER;
        }
        return String.valueOf(userHomePath) + File.separator + USER_HOME_YAKINDU_FOLDER;
    }

    public static List<String> appendAdditionalPathsWithoutDuplicates(List<String> paths, List<String> additionalPaths) {
        if (additionalPaths != null) {
            for (String additionalPath : additionalPaths) {
                if (additionalPath == null) continue;
                if (additionalPath.endsWith(File.separator)) {
                    additionalPath = additionalPath.substring(0, additionalPath.length() - File.separator.length());
                }
                if (paths.contains(additionalPath)) continue;
                paths.add(additionalPath);
            }
        }
        return paths;
    }

    public static List<String> appendAdditionalPath(List<String> paths, String additionalPath) {
        if (additionalPath == null || additionalPath.isEmpty()) {
            return paths;
        }
        LinkedList<String> newPaths = new LinkedList<String>(paths);
        newPaths.add(additionalPath);
        return newPaths;
    }

    public static String getServerPath(ServerSettings serverSettings) {
        if (serverSettings != null && serverSettings != ServerSettings.NOT_AVAILABLE && serverSettings.isEnabled()) {
            return serverSettings.getServerUrl();
        }
        return null;
    }

    public static List<String> getLicensePaths(List<String> defaultPaths, List<String> additionalLicensePaths, String serverPath) {
        ArrayList<String> paths = new ArrayList<String>(defaultPaths);
        PathUtils.appendAdditionalPathsWithoutDuplicates(paths, additionalLicensePaths);
        if (serverPath != null && !serverPath.isEmpty()) {
            paths.add(serverPath);
        }
        return paths;
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

