/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.sexec.launch;

import com.google.common.collect.Iterators;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.types.Type;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.resource.ResourceUtil;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public abstract class BaseLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String FILE_NAME = "filename";
    public static final String DEFAULT_FILE_NAME = "";
    protected Injector injector;

    protected abstract NamedElement loadExecutionRoot(Resource var1);

    protected abstract Module provideSimulationModule();

    protected abstract ISimulationEngine provideRootSimulationEngine(NamedElement var1);

    protected abstract ISimulationEngine provideStatechartSimulationEngine(Statechart var1, ILaunch var2);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Module module = this.provideSimulationModule();
        this.injector = Guice.createInjector((Module[])new Module[]{module});
        this.injector.injectMembers((Object)this);
        String filename = configuration.getAttribute(FILE_NAME, DEFAULT_FILE_NAME);
        Resource resource = this.loadResource(filename);
        NamedElement executionRoot = this.loadExecutionRoot(resource);
        ISimulationEngine simulationEngine = this.createExecutionContainer(launch, executionRoot, monitor);
        SCTDebugTarget target = new SCTDebugTarget(launch, executionRoot, simulationEngine);
        target.setPrimary(true);
        target.init();
        launch.addDebugTarget((IDebugTarget)target);
        this.addStatemachineDebugTargets(launch, target);
        target.start();
    }

    protected Resource loadResource(String filename) {
        return ResourceUtil.loadResource((String)filename);
    }

    protected ISimulationEngine createExecutionContainer(ILaunch launch, NamedElement execRoot, IProgressMonitor monitor) {
        ISimulationEngine engine = this.provideRootSimulationEngine(execRoot);
        this.injector.injectMembers((Object)engine);
        return engine;
    }

    protected void addStatemachineDebugTargets(ILaunch launch, SCTDebugTarget mainTarget) {
        Object _adapter = mainTarget.getAdapter(ExecutionContext.class);
        ExecutionContext context = (ExecutionContext)_adapter;
        Functions.Function1 _function = it -> {
            Type _type = it.getType();
            return _type instanceof ExecutionFlow;
        };
        List statemachineInstances = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)context.eAllContents(), ExecutionContext.class), (Functions.Function1)_function));
        Consumer<ExecutionContext> _function_1 = it -> {
            try {
                SCTDebugTarget machineTarget = this.createSubmachineDebugTarget(launch, this.getStatechart((ExecutionContext)it), it.getFqName());
                Object _adapter_1 = machineTarget.getAdapter(ISimulationEngine.class);
                ISimulationEngine engine = (ISimulationEngine)_adapter_1;
                engine.setExecutionContext(it);
                machineTarget.init();
                launch.addDebugTarget((IDebugTarget)machineTarget);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        statemachineInstances.forEach(_function_1);
    }

    protected SCTDebugTarget createSubmachineDebugTarget(ILaunch launch, Statechart statechart, String context) throws CoreException {
        Assert.isNotNull((Object)statechart);
        ISimulationEngine engine = this.provideStatechartSimulationEngine(statechart, launch);
        return new SCTDebugTarget(launch, (NamedElement)statechart, context, engine);
    }

    protected Statechart getStatechart(ExecutionContext context) {
        EObject _sourceElement;
        Type type = context.getType();
        if (type instanceof ExecutionFlow && (_sourceElement = ((ExecutionFlow)type).getSourceElement()) instanceof Statechart) {
            EObject _sourceElement_1 = ((ExecutionFlow)type).getSourceElement();
            return (Statechart)_sourceElement_1;
        }
        return null;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        String filename = configuration.getAttribute(FILE_NAME, DEFAULT_FILE_NAME);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(filename);
        IProject _project = resource.getProject();
        return new IProject[]{_project};
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }
}

