/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.scoping.IPackageImport2URIMapper;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.stext.ImportScope;
import com.yakindu.sct.model.stext.stext.StateSpecification;
import com.yakindu.sct.model.stext.stext.TransitionSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;

public class StextImportAwareScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    @Inject
    private IPackageImport2URIMapper mapper;
    @Inject
    STextExtensions utils;

    public IScope getScope(EObject context, EReference reference) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        IScope result = null;
        result = context instanceof ImportScope ? this.getResourceScope(context.eResource(), reference) : (context.eContainer() != null ? this.getScope(context.eContainer(), reference) : this.getResourceScope(context.eResource(), reference));
        return this.getLocalElementsScope(result, context, reference);
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        List importScopes = null;
        Statechart statechart = this.utils.getStatechart(context);
        if (statechart == null) {
            return importedNamespaceResolvers;
        }
        importScopes = context instanceof StateSpecification || context instanceof TransitionSpecification ? EcoreUtil2.getAllContentsOfType((EObject)statechart, ImportScope.class) : EcoreUtil2.getAllContentsOfType((EObject)context, ImportScope.class);
        for (ImportScope scope : importScopes) {
            importedNamespaceResolvers.addAll(this.createNamespaceResolver(scope, ignoreCase));
        }
        if (statechart != null && statechart.getNamespace() != null) {
            importedNamespaceResolvers.add(this.createImportedNamespaceResolver(statechart.getNamespace(), ignoreCase));
        }
        return importedNamespaceResolvers;
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return new ImportNormalizer(importedNamespace, true, ignoreCase);
    }

    protected List<ImportNormalizer> createNamespaceResolver(Scope scope, boolean ignoreCase) {
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        ImportScope importScope = (ImportScope)scope;
        for (String child : importScope.getImports()) {
            ImportNormalizer resolver;
            Optional pkgImport = this.mapper.findPackageImport(scope.eResource(), child);
            if (!pkgImport.isPresent() || (resolver = this.createImportedNamespaceResolver(((IPackageImport2URIMapper.PackageImport)pkgImport.get()).getNamespace(), ignoreCase)) == null) continue;
            importedNamespaceResolvers.add(resolver);
        }
        return importedNamespaceResolvers;
    }

    protected String getImportedNamespace(EObject object) {
        if (object instanceof Package) {
            return ((Package)object).getName();
        }
        return super.getImportedNamespace(object);
    }
}

