/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.yakindu.base.expressions.expressions.ReactionTrigger;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.SGraphPackage;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.stext.stext.DefaultTrigger;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class ChoiceValidator
extends STextBaseValidator {
    public static final String ONLY_ONE_DEFAULT_SHOULD_BE_USED = "%s choice should have only one default or else transition.";
    public static final String CHOICE_ONE_OUTGOING_DEFAULT_TRANSITION = "%s choice should have one outgoing default transition.";

    @Check(value=CheckType.FAST)
    public void checkOnlyOneDefaultTransitionUsed(Choice choice) {
        Iterator iterator = choice.getOutgoingTransitions().iterator();
        ArrayList<Transition> defaultTransitions = new ArrayList<Transition>();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            Trigger trigger = transition.getTrigger();
            if (!(trigger instanceof DefaultTrigger) && trigger != null) continue;
            defaultTransitions.add(transition);
        }
        int size = defaultTransitions.size();
        if (size > 1) {
            Iterator iterator2 = defaultTransitions.iterator();
            while (iterator2.hasNext()) {
                String _xifexpression = null;
                String _name = choice.getName();
                boolean _tripleEquals = _name == null;
                _xifexpression = _tripleEquals ? "A" : choice.getName();
                this.warning(String.format(ONLY_ONE_DEFAULT_SHOULD_BE_USED, _xifexpression), (EObject)iterator2.next(), null, -1);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkChoiceWithoutDefaultTransition(Choice choice) {
        boolean found = false;
        EList _outgoingTransitions = choice.getOutgoingTransitions();
        for (Transition transition : _outgoingTransitions) {
            Trigger trigger = transition.getTrigger();
            boolean _isDefault = this.isDefault(trigger);
            if (!_isDefault) continue;
            found = true;
        }
        if (!found) {
            String _xifexpression = null;
            String _name = choice.getName();
            boolean _tripleEquals = _name == null;
            _xifexpression = _tripleEquals ? "A" : choice.getName();
            this.warning(String.format(CHOICE_ONE_OUTGOING_DEFAULT_TRANSITION, _xifexpression), (EStructuralFeature)SGraphPackage.Literals.VERTEX__OUTGOING_TRANSITIONS);
        }
    }

    protected boolean isDefault(Trigger trigger) {
        return trigger == null || trigger instanceof DefaultTrigger || trigger instanceof ReactionTrigger && ((ReactionTrigger)trigger).getTriggers().size() == 0 && ((ReactionTrigger)trigger).getGuard() == null;
    }
}

