/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.resource;

import com.google.common.collect.Maps;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.Operation;
import com.yakindu.base.types.Package;
import com.yakindu.base.types.Parameter;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypedElement;
import com.yakindu.base.types.TypesPackage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

public class TypedResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String HAS_UNKNOWN_TYPE = "has_unknown_type";
    public static final String IS_VISIBLE_TYPE = "is_visible_type";
    public static final String IS_ALIAS_ON_ENUM = "is_alias_on_enum";
    public static final String HAS_COMPLEX_TYPE = "has_complex_type";
    public static final String OPERATION_SIGNATURE = "operation_signature";

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                HashMap userData = Maps.newHashMap();
                this.defineUserData(eObject, userData);
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, (Map)userData));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return eObject instanceof Package || eObject instanceof ComplexType;
    }

    protected void defineUserData(EObject eObject, Map<String, String> userData) {
        if (eObject instanceof TypedElement) {
            userData.put(HAS_UNKNOWN_TYPE, String.valueOf(this.isUnknownType((TypedElement)eObject)));
            userData.put(HAS_COMPLEX_TYPE, String.valueOf(this.hasComplexType((TypedElement)eObject)));
        }
        if (eObject instanceof Type) {
            userData.put(IS_VISIBLE_TYPE, String.valueOf(((Type)eObject).isVisible()));
        }
        if (eObject instanceof TypeAlias && ((TypeAlias)eObject).getOriginType() instanceof EnumerationType) {
            userData.put(IS_ALIAS_ON_ENUM, String.valueOf(true));
        }
    }

    protected boolean isUnknownType(TypedElement element) {
        return false;
    }

    protected boolean hasComplexType(TypedElement element) {
        return false;
    }

    protected String getOperationSignature(Operation operation) {
        if (operation.getName() == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(operation.getName());
        builder.append("(");
        EList<Parameter> parameters = operation.getParameters();
        String sep = "";
        for (Parameter parameter : parameters) {
            builder.append(sep);
            builder.append(parameter.getName());
            builder.append(" : ");
            String typeName = this.getTypeName(parameter.getTypeSpecifier());
            builder.append(typeName);
            sep = ", ";
        }
        builder.append(")");
        if (operation.getType() != null) {
            builder.append(" : ");
            String name = this.getTypeName(operation.getTypeSpecifier());
            builder.append(name == null ? "void" : name);
        }
        return builder.toString();
    }

    protected String getTypeName(TypeSpecifier typeSpecifier) {
        Type type = (Type)typeSpecifier.eGet((EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE, false);
        String typeName = "";
        if (type == null) {
            typeName = "null";
        } else if (type.eIsProxy()) {
            URI eProxyURI = ((InternalEObject)type).eProxyURI();
            typeName = StringUtils.substringAfterLast((String)eProxyURI.fragment(), (String)".");
        } else {
            typeName = type.getName();
        }
        return typeName;
    }
}

