/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.scheduling;

import com.yakindu.core.rx.Observable;
import java.util.List;

public interface ITimeTaskScheduler {
    public void scheduleTimeTask(TimeTask var1, boolean var2, long var3);

    public void unscheduleTimeTask(String var1);

    public void timeLeap(long var1);

    public void cycleLeap(int var1);

    public void start();

    public void suspend();

    public void resume();

    public void step();

    public void terminate();

    public long getCurrentTime();

    public List<TimeTask> getScheduledTimeTasks();

    public Observable<Void> scheduleChanged();

    public static class TimeTask
    implements Runnable,
    Comparable<TimeTask> {
        public static final String CYCLE_TASK_NAME = "$cycle";
        private long nextExecutionTime = 0L;
        long period = -1L;
        long scheduleOrder = 0L;
        boolean isCanceled = false;
        Priority priority = Priority.NORMAL;
        String name;
        private final Runnable callBack;

        public TimeTask(String name, Runnable callBack) {
            this(name, callBack, Priority.NORMAL);
        }

        public TimeTask(String name, Runnable callBack, Priority priority) {
            this.callBack = callBack;
            this.name = name;
            this.priority = priority;
        }

        @Override
        public void run() {
            this.callBack.run();
        }

        @Override
        public int compareTo(TimeTask other) {
            long diff = 0L;
            diff = this.nextExecutionTime != other.nextExecutionTime ? this.nextExecutionTime - other.nextExecutionTime : (other.priority != this.priority ? (long)(other.priority.getIntValue() - this.priority.getIntValue()) : (this.period != other.period ? this.period - other.period : this.scheduleOrder - other.scheduleOrder));
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void cancel() {
            this.isCanceled = true;
        }

        public long getNextExecutionTime() {
            return this.nextExecutionTime;
        }

        public void setNextExecutionTime(long nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }

        public String getName() {
            return this.name;
        }

        public void setPeriod(long period) {
            this.period = period;
        }

        public static enum Priority {
            LOW(0),
            NORMAL(50),
            HIGH(100);

            private int intValue;

            private Priority(int prio) {
                this.intValue = prio;
            }

            public int getIntValue() {
                return this.intValue;
            }
        }
    }
}

