/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.google.common.collect.Iterables;
import com.yakindu.base.types.Trigger;
import com.yakindu.sct.model.sgraph.Choice;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sgraph.Synchronization;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.SGgraphUtil;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class SynchronizationValidator
extends AbstractSGraphValidator {
    public static final String SYNCHRONIZATION_MULTIPLE_TARGET_SAME_REGION_MSG = "Synchronization node(s) connected to this one result(s) in multiple states to be active in the same region at the same time. This would result in an inconsistent state.";
    public static final String SYNCHRONIZATION_MULTIPLE_TARGET_SAME_REGION_CODE = "synchronization.transitions.MultipleTargetSameRegion";
    public static final String SYNCHRONIZATION_TRANSITIONS_REQUIRE_N_OUT_MSG = "A synchronization must have at least one outgoing transition.";
    public static final String SYNCHRONIZATION_TRANSITIONS_REQUIRE_N_OUT_CODE = "synchronization.transitions.RequireNOut";
    public static final String SYNCHRONIZATION_TRANSITIONS_REQUIRE_MULTIPLE_IN_OR_MULTIPLE_OUT_MSG = "A synchronization must have either multiple incoming or multiple outgoing transitions.";
    public static final String SYNCHRONIZATION_TRANSITIONS_REQUIRE_MULTIPLE_IN_OR_MULTIPLE_OUT_CODE = "synchronization.transitions.RequireMultipleInOrMultipleOut";
    public static final String SYNCHRONIZATION_REQUIRES_ORTHOGONAL_SOURCE_STATES_MSG = "The source states of a synchronization must be orthogonal.";
    public static final String SYNCHRONIZATION_REQUIRES_ORTHOGONAL_SOURCE_STATES_CODE = "synchronization.RequiresOrthogonalSourceStates";
    public static final String SYNCHRONIZATION_REQUIRES_ORTHOGONAL_TARGET_STATES_MSG = "The target states of a synchronization must be orthogonal.";
    public static final String SYNCHRONIZATION_REQUIRES_ORTHOGONAL_TARGET_STATES_CODE = "synchronization.RequiresOrthogonalTargetStates";
    public static final String SYNCHRONIZATION_OUTGOING_TRIGGER_MSG = "Triggers and guards on a synchronization's outgoing transitions will be ignored.";
    public static final String SYNCHRONIZATION_OUTGOING_TRIGGER_CODE = "synchronization.NoOutgoingTrigger";
    public static final String SYNCHRONIZATION_TARGET_EXIT_MSG = "An exit node can not be the target of a synchronization node. Please target the exit node's destination directly.";
    public static final String SYNCHRONIZATION_TARGET_EXIT_CODE = "synchronization.InvalidTargetExitNode";
    public static final String SYNCHRONIZATION_REQUIRES_TARGET_STATES_EXCLUSIVE_TO_SOURCE_STATES_MSG = "A synchronization's target states must be exclusive to it's source states. (Common ancestor must be a region.)";
    public static final String SYNCHRONIZATION_REQUIRES_TARGET_STATES_EXCLUSIVE_TO_SOURCE_STATES_CODE = "synchronization.RequiresTargetStatesExclusiveToSourceStates";
    public static final String SYNCHRONIZATION_REQUIRES_SOURCE_STATES_ORTHOGONAL_TO_TARGET_STATES_MSG = "A synchronization's source states must be orthogonal to it's target states. (Common ancestor must be a region.)";
    public static final String SYNCHRONIZATION_REQUIRES_SOURCE_STATES_ORTHOGONAL_TO_TARGET_STATES_CODE = "synchronization.RequiresSourceStatesOrthogonalToTargetStates";
    public static final String SYNCHRONIZATION_JOIN_INVALID_SOURCE_MSG = "All incoming transitions sources of a join (synchronization) must be regular states.";
    public static final String SYNCHRONIZATION_JOIN_INVALID_SOURCE_CODE = "synchronization.JoinInvalidSourceNode";

    private List<Transition> _syncChain(Synchronization sync, List<Transition> transitionList, Set<Vertex> traversed) {
        List<Transition> _xblockexpression = null;
        Functions.Function1 _function = t -> !(t.getTarget() instanceof Synchronization) && !(t.getTarget() instanceof Choice);
        Iterable _filter = IterableExtensions.filter(sync.getOutgoingTransitions(), (Functions.Function1)_function);
        Iterables.addAll(transitionList, (Iterable)_filter);
        Functions.Function1 _function_1 = t -> (t.getTarget() instanceof Synchronization || t.getTarget() instanceof Choice) && t.getTarget() != sync && !traversed.contains(sync);
        Consumer<Transition> _function_2 = it -> {
            traversed.add(sync);
            this.syncChain(it.getTarget(), transitionList, traversed);
        };
        IterableExtensions.filter(sync.getOutgoingTransitions(), (Functions.Function1)_function_1).forEach(_function_2);
        _xblockexpression = transitionList;
        return _xblockexpression;
    }

    private List<Transition> _syncChain(Choice choice, List<Transition> transitionList, Set<Vertex> traversed) {
        List<Transition> _xblockexpression = null;
        Functions.Function1 _function = t -> {
            Vertex _target = t.getTarget();
            return _target instanceof Synchronization;
        };
        Consumer<Transition> _function_1 = it -> {
            traversed.add(choice);
            this.syncChain(it.getTarget(), transitionList, traversed);
        };
        IterableExtensions.filter(choice.getOutgoingTransitions(), (Functions.Function1)_function).forEach(_function_1);
        _xblockexpression = transitionList;
        return _xblockexpression;
    }

    private List<Transition> _syncChain(Vertex vertex, List<Transition> transitionList, Set<Vertex> traversed) {
        return transitionList;
    }

    private List<Transition> syncChain(Synchronization sync) {
        return this.syncChain(sync, CollectionLiterals.newArrayList(), CollectionLiterals.newHashSet());
    }

    @Check(value=CheckType.FAST)
    public void checkSynchronizationHasTargetToSameRegion(Synchronization it) {
        if (!SGgraphUtil.areOrthogonal(ListExtensions.map(this.syncChain(it), it_1 -> it_1.getTarget())) && SGgraphUtil.areOrthogonal(ListExtensions.map(it.getOutgoingTransitions(), it_1 -> it_1.getTarget()))) {
            this.error(SYNCHRONIZATION_MULTIPLE_TARGET_SAME_REGION_MSG, (EObject)it, null, -1, SYNCHRONIZATION_MULTIPLE_TARGET_SAME_REGION_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkSynchronizationTransitionsRequireNOut(Synchronization it) {
        boolean _equals;
        int _size = it.getOutgoingTransitions().size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            this.error(SYNCHRONIZATION_TRANSITIONS_REQUIRE_N_OUT_MSG, (EObject)it, null, -1, SYNCHRONIZATION_TRANSITIONS_REQUIRE_N_OUT_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkSynchronizationTransitionsRequireMultipleInOrMultipleOut(Synchronization it) {
        if (it.getIncomingTransitions().size() < 2 && it.getOutgoingTransitions().size() < 2) {
            this.error(SYNCHRONIZATION_TRANSITIONS_REQUIRE_MULTIPLE_IN_OR_MULTIPLE_OUT_MSG, (EObject)it, null, -1, SYNCHRONIZATION_TRANSITIONS_REQUIRE_MULTIPLE_IN_OR_MULTIPLE_OUT_CODE, new String[0]);
        }
    }

    @Check
    public void checkSynchronizationRequiresOrthogonalSourceStates(Synchronization it) {
        boolean _not;
        Functions.Function1 _function = it_1 -> it_1.getSource();
        boolean _areOrthogonal = SGgraphUtil.areOrthogonal(ListExtensions.map(it.getIncomingTransitions(), (Functions.Function1)_function));
        boolean bl = _not = !_areOrthogonal;
        if (_not) {
            this.error(SYNCHRONIZATION_REQUIRES_ORTHOGONAL_SOURCE_STATES_MSG, (EObject)it, null, -1, SYNCHRONIZATION_REQUIRES_ORTHOGONAL_SOURCE_STATES_CODE, new String[0]);
        }
    }

    @Check
    public void checkSynchronizationRequiresOrthogonalTargetStates(Synchronization it) {
        boolean _not;
        Functions.Function1 _function = it_1 -> it_1.getTarget();
        boolean _areOrthogonal = SGgraphUtil.areOrthogonal(ListExtensions.map(it.getOutgoingTransitions(), (Functions.Function1)_function));
        boolean bl = _not = !_areOrthogonal;
        if (_not) {
            this.error(SYNCHRONIZATION_REQUIRES_ORTHOGONAL_TARGET_STATES_MSG, (EObject)it, null, -1, SYNCHRONIZATION_REQUIRES_ORTHOGONAL_TARGET_STATES_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkSyncNoTriggersOnOutgoingTransition(Synchronization sync) {
        Functions.Function1 _function = t -> {
            Trigger _trigger = t.getTrigger();
            return _trigger != null;
        };
        Consumer<Transition> _function_1 = it -> this.warning(SYNCHRONIZATION_OUTGOING_TRIGGER_MSG, (EObject)it, null, -1, SYNCHRONIZATION_OUTGOING_TRIGGER_CODE, new String[0]);
        IterableExtensions.filter(sync.getOutgoingTransitions(), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check(value=CheckType.FAST)
    public void checkSyncNoExitNodeAsOutgoingTransitionTarget(Synchronization sync) {
        Functions.Function1 _function = t -> {
            Vertex _target = t.getTarget();
            return _target instanceof Exit;
        };
        Consumer<Transition> _function_1 = it -> this.error(SYNCHRONIZATION_TARGET_EXIT_MSG, (EObject)it, null, -1, SYNCHRONIZATION_TARGET_EXIT_CODE, new String[0]);
        IterableExtensions.filter(sync.getOutgoingTransitions(), (Functions.Function1)_function).forEach(_function_1);
    }

    @Check
    public Object checkSynchronizationRequiresSourceStatesOrthogonalToTargetStates(Synchronization it) {
        Object _xifexpression = null;
        if (it.getIncomingTransitions().size() == 1 && ((Transition)IterableExtensions.head(it.getIncomingTransitions())).getSource() instanceof Synchronization) {
            _xifexpression = null;
        } else {
            Consumer<Transition> _function = i -> {
                Consumer<Transition> _function_1 = j -> {
                    Vertex _target;
                    Vertex _source = i.getSource();
                    boolean _areOrthogonal = SGgraphUtil.areOrthogonal(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Vertex[]{_source, _target = j.getTarget()})));
                    if (_areOrthogonal) {
                        boolean _greaterThan;
                        int _size = it.getIncomingTransitions().size();
                        boolean bl = _greaterThan = _size > 1;
                        if (_greaterThan) {
                            this.error(SYNCHRONIZATION_REQUIRES_SOURCE_STATES_ORTHOGONAL_TO_TARGET_STATES_MSG, (EObject)i, null, -1, SYNCHRONIZATION_REQUIRES_SOURCE_STATES_ORTHOGONAL_TO_TARGET_STATES_CODE, new String[0]);
                            this.error(SYNCHRONIZATION_REQUIRES_SOURCE_STATES_ORTHOGONAL_TO_TARGET_STATES_MSG, (EObject)j, null, -1, SYNCHRONIZATION_REQUIRES_SOURCE_STATES_ORTHOGONAL_TO_TARGET_STATES_CODE, new String[0]);
                        } else {
                            this.error(SYNCHRONIZATION_REQUIRES_TARGET_STATES_EXCLUSIVE_TO_SOURCE_STATES_MSG, (EObject)i, null, -1, SYNCHRONIZATION_REQUIRES_TARGET_STATES_EXCLUSIVE_TO_SOURCE_STATES_CODE, new String[0]);
                            this.error(SYNCHRONIZATION_REQUIRES_TARGET_STATES_EXCLUSIVE_TO_SOURCE_STATES_MSG, (EObject)j, null, -1, SYNCHRONIZATION_REQUIRES_TARGET_STATES_EXCLUSIVE_TO_SOURCE_STATES_CODE, new String[0]);
                        }
                    }
                };
                it.getOutgoingTransitions().forEach(_function_1);
            };
            it.getIncomingTransitions().forEach(_function);
        }
        return _xifexpression;
    }

    @Check(value=CheckType.FAST)
    public void checkSyncJoinRegularStates(Synchronization sync) {
        boolean _greaterThan;
        int _size = sync.getIncomingTransitions().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Functions.Function1 _function = t -> {
                Vertex _source = t.getSource();
                return !(_source instanceof RegularState);
            };
            Consumer<Transition> _function_1 = it -> this.error(SYNCHRONIZATION_JOIN_INVALID_SOURCE_MSG, (EObject)it, null, -1, SYNCHRONIZATION_JOIN_INVALID_SOURCE_CODE, new String[0]);
            IterableExtensions.filter(sync.getIncomingTransitions(), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    @XbaseGenerated
    private List<Transition> syncChain(Vertex choice, List<Transition> transitionList, Set<Vertex> traversed) {
        if (choice instanceof Choice) {
            return this._syncChain((Choice)choice, transitionList, traversed);
        }
        if (choice instanceof Synchronization) {
            return this._syncChain((Synchronization)choice, transitionList, traversed);
        }
        if (choice != null) {
            return this._syncChain(choice, transitionList, traversed);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(choice, transitionList, traversed).toString());
    }
}

