/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.sgraph.validation;

import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.sgraph.util.DFS;
import com.yakindu.sct.model.sgraph.validation.AbstractSGraphValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class VertexValidator
extends AbstractSGraphValidator {
    private static final String VERTEX_MUST_BE_REACHABLE_MSG = "Node is not reachable.";
    public static final String VERTEX_MUST_BE_REACHABLE_CODE = "vertex.MustBeReachable";

    @Check(value=CheckType.FAST)
    public void checkVertexMustBeReachable(Vertex vertex) {
        if (!(vertex instanceof Entry)) {
            final HashSet<Object> stateScopeSet = new HashSet<Object>();
            for (EObject obj : EcoreUtil2.eAllContents((EObject)vertex)) {
                stateScopeSet.add(obj);
            }
            stateScopeSet.add(vertex);
            final ArrayList externalPredecessors = new ArrayList();
            DFS dfs = new DFS(){

                @Override
                public Iterator<Object> getElementLinks(Object element) {
                    ArrayList<Object> elements = new ArrayList<Object>();
                    if (element instanceof State) {
                        if (!stateScopeSet.contains(element)) {
                            externalPredecessors.add(element);
                        }
                        elements.addAll((Collection<Object>)((State)element).getRegions());
                        elements.addAll((Collection<Object>)((State)element).getIncomingTransitions());
                    } else if (element instanceof Region) {
                        elements.addAll((Collection<Object>)((Region)element).getVertices());
                    } else if (element instanceof Entry) {
                        if (!stateScopeSet.contains(element)) {
                            externalPredecessors.add(element);
                        } else {
                            elements.addAll((Collection<Object>)((Entry)element).getIncomingTransitions());
                        }
                    } else if (element instanceof Vertex) {
                        elements.addAll((Collection<Object>)((Vertex)element).getIncomingTransitions());
                    } else if (element instanceof Transition) {
                        elements.add(((Transition)element).getSource());
                    }
                    return elements.iterator();
                }
            };
            dfs.perform(vertex);
            if (externalPredecessors.size() == 0 || !externalPredecessors.stream().filter(o -> o instanceof Entry).findFirst().isPresent()) {
                this.error(VERTEX_MUST_BE_REACHABLE_MSG, (EObject)vertex, null, -1, VERTEX_MUST_BE_REACHABLE_CODE, new String[0]);
            }
        }
    }
}

