/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.util;

import com.google.common.collect.Iterables;
import com.yakindu.base.types.Direction;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ExecutionSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ExecutionContextExtensions {
    public void clearOutEvents(ExecutionContext executionContext) {
        Functions.Function1 _function = it -> this.isOwner(executionContext, (ExecutionSlot)it);
        Functions.Function1 _function_1 = it -> {
            Direction _direction = it.getDirection();
            return Objects.equals(_direction, Direction.OUT);
        };
        Consumer<ExecutionEvent> _function_2 = it -> {
            boolean _isRaised = it.isRaised();
            if (_isRaised) {
                it.setRaised(false);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)executionContext.getAllEvents(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    public void clearLocalAndInEvents(ExecutionContext executionContext) {
        Functions.Function1 _function = it -> this.isOwner(executionContext, (ExecutionSlot)it);
        Functions.Function1 _function_1 = it -> Objects.equals(it.getDirection(), Direction.IN) || Objects.equals(it.getDirection(), Direction.LOCAL);
        Consumer<ExecutionEvent> _function_2 = it -> {
            boolean _isRaised = it.isRaised();
            if (_isRaised) {
                it.setRaised(false);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)executionContext.getAllEvents(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    public List<RegularState> getAllActiveStates(ExecutionContext context) {
        Functions.Function1 _function = it -> this.getStateHierachy((RegularState)it);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)context.getActiveStates(), RegularState.class), (Functions.Function1)_function)));
    }

    protected ArrayList<RegularState> getStateHierachy(RegularState state) {
        ArrayList<RegularState> result = new ArrayList<RegularState>();
        result.add(state);
        EObject container = state.eContainer();
        while (container != null) {
            if (container instanceof RegularState) {
                result.add((RegularState)container);
            }
            container = container.eContainer();
        }
        return result;
    }

    protected boolean isOwner(ExecutionContext context, ExecutionSlot it) {
        ExecutionSlot declaration = it;
        while (!(declaration.eContainer() instanceof ExecutionContext)) {
            declaration = declaration.eContainer();
        }
        EObject _eContainer = declaration.eContainer();
        return Objects.equals(context, _eContainer);
    }
}

