/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor;

import com.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import com.yakindu.sct.refactoring.refactor.IRefactoring;
import com.yakindu.sct.refactoring.utils.RefactoringHelper;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public abstract class AbstractRefactoring<T>
implements IRefactoring<T> {
    private List<T> contextObjects;
    protected RefactoringHelper helper = new RefactoringHelper();

    public void setContextObjects(List<T> contextObject) {
        this.contextObjects = contextObject;
    }

    public List<T> getContextObjects() {
        return this.contextObjects;
    }

    public T getContextObject() {
        return this.getContextObjects().iterator().next();
    }

    @Override
    public boolean isExecutable() {
        return this.getContextObjects() != null && this.getContextObjects().size() > 0;
    }

    protected Resource getResource() {
        T firstContextObject = this.getContextObject();
        if (firstContextObject instanceof EObject) {
            return ((EObject)firstContextObject).eResource();
        }
        return null;
    }

    @Override
    public void execute() {
        if (!this.isExecutable()) {
            return;
        }
        AbstractTransactionalCommand refactoringCommand = new AbstractTransactionalCommand(this.getEditingDomain(), this.getCommandLabel(), this.getAffectedFiles()){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    AbstractRefactoring.this.executeRefactoring();
                }
                catch (Exception ex) {
                    return CommandResult.newErrorCommandResult((Throwable)ex);
                }
                return CommandResult.newOKCommandResult();
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (AbstractRefactoring.this.internalDoUndo()) {
                    return super.doUndo(monitor, info);
                }
                return Status.CANCEL_STATUS;
            }
        };
        this.executeCommand(refactoringCommand);
    }

    protected void executeCommand(AbstractTransactionalCommand refactoringCommand) {
        AbstractRefactoring.executeCommand((IUndoableOperation)refactoringCommand, this.getResource());
    }

    protected boolean internalDoUndo() {
        return true;
    }

    protected void executeRefactoring() {
        this.internalExecute();
        this.parseAndLinkSpecificationElements();
    }

    protected abstract void internalExecute();

    protected void parseAndLinkSpecificationElements() {
        Resource resource = this.getResource();
        if (resource instanceof AbstractSCTResource) {
            ((AbstractSCTResource)resource).parseSpecificationElements();
            ((AbstractSCTResource)resource).linkSpecificationElements();
        }
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return TransactionUtil.getEditingDomain((Resource)this.getResource());
    }

    protected List<?> getAffectedFiles() {
        return Collections.EMPTY_LIST;
    }

    protected String getCommandLabel() {
        return "Refactoring Command";
    }

    public static void executeCommand(IUndoableOperation command, Resource resource) {
        AbstractRefactoring.executeCommand(command, resource, true);
    }

    public static void executeCommand(IUndoableOperation command, Resource resource, boolean serialize) {
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        if (resource instanceof AbstractSCTResource) {
            ((AbstractSCTResource)resource).setSerializerEnabled(serialize);
            try {
                try {
                    history.execute(command, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    ((AbstractSCTResource)resource).setSerializerEnabled(false);
                }
            }
            finally {
                ((AbstractSCTResource)resource).setSerializerEnabled(false);
            }
        } else {
            try {
                history.execute(command, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    protected String asIdentifier(String string) {
        return string.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", "_");
    }
}

