/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.cpp;

import com.google.inject.Inject;
import com.yakindu.base.types.ComplexType;
import com.yakindu.base.types.EnumerationType;
import com.yakindu.base.types.PrimitiveType;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeAlias;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.sct.generator.c.types.CTypeSystemAccess;
import com.yakindu.sct.generator.cpp.CppFileNaming;
import com.yakindu.sct.generator.cpp.CppNaming;
import com.yakindu.sct.generator.cpp.types.CppTypes;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CppTypeSystemAccess
extends CTypeSystemAccess {
    @Inject
    @Extension
    protected CppNaming _cppNaming;
    @Inject
    @Extension
    protected CppFileNaming _cppFileNaming;
    @Inject
    @Extension
    protected CppTypes _cppTypes;

    public String printStateEnumType(EnumerationType type) {
        String _module = this._cppFileNaming.module(this._statechartUtil.getOriginStatechart((EObject)type));
        String _plus = _module + "::";
        String _name = type.getName();
        return _plus + _name;
    }

    public String printStatechartType(ComplexType type) {
        String _xblockexpression = null;
        List<String> namespace = this._cppNaming.statechartNamespace(this._statechartUtil.getOriginStatechart((EObject)type));
        Functions.Function1 _function = it -> it;
        String _join = IterableExtensions.join(namespace, (CharSequence)"", (CharSequence)"::", (CharSequence)"::", (Functions.Function1)_function);
        String _module = this._cppFileNaming.module(this._statechartUtil.getOriginStatechart((EObject)type));
        String _plus = _join + _module;
        _xblockexpression = _plus + "*";
        return _xblockexpression;
    }

    protected String targetLanguageSpecifier(TypeSpecifier tspec, String typeLiteral) {
        Object typeSpecLiteral = typeLiteral;
        if (tspec != null && !tspec.getTypeArguments().isEmpty()) {
            String _typeSpecLiteral = typeSpecLiteral;
            Functions.Function1 _function = it -> this.targetLanguageSpecifier((TypeSpecifier)it);
            String _replaceAll = IterableExtensions.join((Iterable)tspec.getTypeArguments(), (CharSequence)"<", (CharSequence)",", (CharSequence)">", (Functions.Function1)_function).replaceAll(">>", "> >");
            typeSpecLiteral = _typeSpecLiteral + _replaceAll;
        }
        return typeSpecLiteral;
    }

    protected String _targetLanguageName(PrimitiveType it) {
        boolean _isString;
        boolean _isStringLiteral;
        boolean _isBoolean;
        boolean _isReal;
        boolean _isInteger;
        boolean _isVoid;
        String _switchResult = null;
        boolean _matched = false;
        boolean _isSame = this._iTypeSystem.isSame((Type)it, this._iTypeSystem.getType("bool"));
        if (_isSame) {
            _matched = true;
            _switchResult = this._cppTypes.sc_bool().fqName();
        }
        if (!_matched && (_isVoid = this._iTypeSystem.isVoid((Type)it))) {
            _matched = true;
            _switchResult = this._cppTypes.sc_void().name();
        }
        if (!_matched && (_isInteger = this._iTypeSystem.isInteger((Type)it))) {
            _matched = true;
            _switchResult = this._cppTypes.sc_integer().fqName();
        }
        if (!_matched && (_isReal = this._iTypeSystem.isReal((Type)it))) {
            _matched = true;
            _switchResult = this._cppTypes.sc_real().fqName();
        }
        if (!_matched && (_isBoolean = this._iTypeSystem.isBoolean((Type)it))) {
            _matched = true;
            _switchResult = this._cppTypes.sc_bool().fqName();
        }
        if (!_matched && (_isStringLiteral = this._iTypeSystem.isStringLiteral((Type)it))) {
            _matched = true;
            _switchResult = this._cppTypes.sc_string().fqName();
        }
        if (!_matched && (_isString = this._iTypeSystem.isString((Type)it))) {
            _matched = true;
            _switchResult = this._cppTypes.sc_string().fqName();
        }
        if (!_matched) {
            _switchResult = this._literals.asLiteral((Object)it);
        }
        return _switchResult;
    }

    protected String _targetLanguageName(Type it, TypeSpecifier tspec) {
        String _switchResult = null;
        boolean _matched = false;
        boolean _isBuiltInType = this._iTypeSemantics.isBuiltInType(it);
        if (_isBuiltInType) {
            _matched = true;
            _switchResult = this.printBuiltInType(tspec);
        }
        if (!_matched) {
            _switchResult = this.targetLanguageSpecifier(tspec, this.targetLanguageName(it));
        }
        return _switchResult;
    }

    protected String _targetLanguageName(ComplexType it) {
        String _switchResult = null;
        boolean _matched = false;
        boolean _isInternalStatemachineType = this._statemachineTypes.isInternalStatemachineType((EObject)it);
        if (_isInternalStatemachineType) {
            _matched = true;
            _switchResult = this.printInternalStatechartType(it);
        }
        if (!_matched) {
            _switchResult = super._targetLanguageName(it);
        }
        return _switchResult;
    }

    protected String printInternalStatechartType(ComplexType type) {
        Object _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)type.getSuperTypes());
        if (_isNullOrEmpty) {
            String _string = type.toString();
            _xifexpression = _string + "Interface*";
        } else {
            _xifexpression = type.toString().replace("Statemachine", "Interface*");
        }
        return "sc::" + (String)_xifexpression;
    }

    public String pointerSymbol(TypeSpecifier it) {
        return "*";
    }

    @XbaseGenerated
    protected String targetLanguageName(Type it) {
        if (it instanceof EnumerationType) {
            return this._targetLanguageName((EnumerationType)it);
        }
        if (it instanceof ComplexType) {
            return this._targetLanguageName((ComplexType)it);
        }
        if (it instanceof PrimitiveType) {
            return this._targetLanguageName((PrimitiveType)it);
        }
        if (it instanceof TypeAlias) {
            return this._targetLanguageName((TypeAlias)it);
        }
        if (it != null) {
            return this._targetLanguageName(it);
        }
        return this._targetLanguageName(null);
    }

    @XbaseGenerated
    public String targetLanguageName(Type it, TypeSpecifier tspec) {
        if (it instanceof TypeAlias) {
            return this._targetLanguageName((TypeAlias)it, tspec);
        }
        if (it != null) {
            return this._targetLanguageName(it, tspec);
        }
        if (it == null) {
            return this._targetLanguageName(null, tspec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, tspec).toString());
    }
}

