/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Package
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.templates.SexecGenerator
import com.yakindu.sct.generator.core.templates.TraceCodeGenerator
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.CheckRef
import com.yakindu.sct.model.sexec.DoWhile
import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.HistoryEntry
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.SaveHistory
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.StateSwitch
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sexec.concepts.MicroStep
import com.yakindu.sct.model.sexec.concepts.SuperStep
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import org.eclipse.emf.ecore.EObject

import static com.yakindu.sct.generator.c.CGeneratorConstants.*
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * @author axel terfloth
 */
class FlowCode extends SexecGenerator {
	
	@Inject extension Naming
	@Inject protected extension CTypes
	@Inject extension CExpressionsGenerator
	@Inject extension INamingService
	@Inject extension TraceCodeGenerator 
	@Inject protected extension StatechartAnnotations
	
	@Inject protected extension SuperStep
	@Inject protected extension MicroStep
	
	@Inject protected extension Literals
	@Inject protected extension SgraphExtensions
	
	
	override dispatch CharSequence code(NamedElement it) '''
		#error ActionCode for Step '«getClass().name»' not defined
	'''
	

	def dispatch CharSequence code(SaveHistory it) '''
		«stepComment»
		«scHandle»->«HISTORYVECTOR»[«region.historyVector.offset»] = «scHandle»->«STATEVECTOR»[«region.stateVector.offset»];
	'''
	
	def dispatch CharSequence code(HistoryEntry it) '''
		«stepComment»
		if («scHandle»->«HISTORYVECTOR»[«region.historyVector.offset»] != «null_state»)
		{
			«historyStep.code»
		} «IF initialStep !== null»else
		{
			«initialStep.code»
		} «ENDIF»
	'''

	def dispatch CharSequence code(StateSwitch it) '''
		«stepComment»
		«IF historyRegion !== null»
			switch(«scHandle»->«HISTORYVECTOR»[ «historyRegion.historyVector.offset» ])
			{
		«ELSE»
			switch(«scHandle»->«STATEVECTOR»[ «stateConfigurationIdx» ])
			{
		«ENDIF»
			«FOR caseid : cases»
				case «caseid.state.stateName» :
				{
					«IF caseid.step !== null»«caseid.step.code»«ENDIF»
					break;
				}
			«ENDFOR»
			default: 
				/* do nothing */
				break;
		}
	'''

	def dispatch CharSequence code(ScheduleTimeEvent it) '''
		«stepComment»
		«flow.setTimerFctID»(«scHandle», («sc_eventid.name») &(«scHandle»->timeEvents.«timeEvent.shortName»_raised) , «timeValue.code», «IF timeEvent.periodic»bool_true«ELSE»bool_false«ENDIF»);
		«traceCode»
	'''

	def dispatch CharSequence code(UnscheduleTimeEvent it) '''
		«stepComment»
		«flow.unsetTimerFctID»(«scHandle», («sc_eventid.name») &(«scHandle»->timeEvents.«timeEvent.shortName»_raised) );		
		«traceCode»
	'''
	
	def dispatch CharSequence code(Call it)
		'''«step.shortName»(«scHandle»);'''


	def dispatch CharSequence code(Check it)
		'''«IF condition !== null»«condition.sc_boolean_code»«ELSE»«TRUE_LITERAL»«ENDIF»'''
	
	def dispatch CharSequence code(CheckRef it)
		'''«IF check !== null»«check.shortName»(«scHandle») == «TRUE_LITERAL»«ELSE»«TRUE_LITERAL»«ENDIF»'''

	def dispatch CharSequence code(If it) '''
		«stepComment»
		if («check.code»)
		{ 
			«thenStep.code»
		} «IF (elseStep !== null)» else
		{
			«elseStep.code»
		}
		«ENDIF»
	'''
	
	def dispatch CharSequence code(DoWhile it) '''
		«stepComment»
		do
		{ 
			«body.code»
		} while («check.code»);
	'''
	
	def dispatch CharSequence code(EnterState it) {
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		'''
			«FOR i: firstPos .. lastPos»
				«scHandle»->«STATEVECTOR»[«i»] = «state.stateName»;
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				«scHandle»->«MicroStep.STATE_VECTOR_POSITION» = «firstPos»;
			«ENDIF»
			«flow._stateChanged.code»
		'''
	}

	def dispatch CharSequence code(ExitState it) {
		val parentState = it.state.sourceElement.parentState
		val stateName = if ( parentState !== null ) parentState.stateName else null_state
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		'''
			«FOR i: firstPos .. lastPos»
				«scHandle»->«STATEVECTOR»[«i»] = «stateName»;
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				«scHandle»->«MicroStep.STATE_VECTOR_POSITION» = «lastPos»;
			«ENDIF»
		'''
	}
	
	// Included in newer Java Versions, remove past Java 11
	protected def stripTrailing(String it) {
		var int pos = it.length - 1
		
		while (pos >= 0 && Character.isWhitespace(it.charAt(pos))) {
			pos -= 1
		}
		
		return it.substring(0, pos + 1)
	}

	def unusedParam(String s) '''
		SC_UNUSED(«s»);
	'''
	
	def requiresHandles(Step it) {
		it.eAllContents.filter[e | e.requiresHandle].size > 0
	}
	 
	def dispatch requiresHandle(EObject e) { false }
	def dispatch requiresHandle(Call e) { true }
	def dispatch requiresHandle(CheckRef e) { true }
	def dispatch requiresHandle(ElementReferenceExpression e) {(e.reference.isMethod) || (! (e.reference instanceof Parameter)) && (!e.reference.isLocalVariable) && (!e.reference.declaredInHeader) }
	def dispatch requiresHandle(FeatureCall e) { ! ((e.feature instanceof Parameter) || e.feature.isLocalVariable) }
	def dispatch requiresHandle(ScheduleTimeEvent it) { true }
	def dispatch requiresHandle(UnscheduleTimeEvent it) { true }
	def dispatch requiresHandle(EnterState it) { true }
	def dispatch requiresHandle(ExitState it) { true }
	def dispatch requiresHandle(HistoryEntry it) { true }
	def dispatch requiresHandle(SaveHistory it) { true }
	def dispatch requiresHandle(StateSwitch it) { true }
	
	def isLocalVariable(EObject o) {
		(o instanceof Property) && (o.eContainer instanceof LocalVariableDefinition)	
	}
	
	def declaredInHeader(EObject o) {
		return (o.eContainer instanceof Package || (o.eContainer instanceof ComplexType && !(o.eContainer instanceof ExecutionFlow)))
	}
	
	def isMethod(EObject o){
		return o instanceof Method
	}
	
	
}
