/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService

/**
 * @author René Beckmann
 */
@Singleton // Guice
class EventNaming {
	
	@Inject extension Naming
	@Inject extension FileNaming
	@Inject extension INamingService
	@Inject extension SExecExtensions
	@Inject extension ICodegenTypeSystemAccess

	def eventEnumMemberName(Event it) {
		#[enumMemberNamePrefix, name.asEscapedIdentifier].filter[!nullOrEmpty].join("_")
	}
	
	def invalidEventEnumName(ExecutionFlow it) {
		#[enumMemberNamePrefix, "invalid_event"].filter[!nullOrEmpty].join("_")
	}

	def eventEnumName(ExecutionFlow it) {
		'''«containerType»EventID'''
	}

	def eventValueUnionName(ExecutionFlow it) {
		'''«module»_event_value'''.toString.toLowerCase
	}
	
	def eventValueUnionMemberName(Event it) {
		'''«eventEnumMemberName»_value'''
	}

	def internalEventStructTypeName(ExecutionFlow it) {
		'''«name»_event'''.toString.toLowerCase
	}

	def eventQueueTypeName(ExecutionFlow it) {
		'''«name»_eventqueue'''.toString.toLowerCase
	}

	def eventInitFunction(ExecutionFlow it) {
		'''«internalEventStructTypeName»_init'''
	}

	def valueEventInitFunction(ExecutionFlow it) {
		'''«internalEventStructTypeName»_value_init'''
	}

	def eventQueueInitFunction(ExecutionFlow it) {
		'''«eventQueueTypeName»_init'''
	}

	def eventQueueSizeFunction(ExecutionFlow it) {
		'''«eventQueueTypeName»_size'''
	}

	def eventQueuePopFunction(ExecutionFlow it) {
		'''«eventQueueTypeName»_pop'''
	}

	def eventQueuePushFunction(ExecutionFlow it) {
		'''«eventQueueTypeName»_push'''
	}
	
	def queueBufferSize(ExecutionFlow it) {
		'''«name»_eventqueue_buffersize'''.toString.toUpperCase
	}
	
	def internalBufferSize(ExecutionFlow it) {
		'''«name»_internal_eventqueue_buffersize'''.toString.toUpperCase
	}
	
	def inBufferSize(ExecutionFlow it) {
		'''«name»_in_eventqueue_buffersize'''.toString.toUpperCase
	}
	
	def invalidEvent() {
		"SC_INVALID_EVENT_VALUE"
	}
	
	def internalQueue() {
		"internal_event_queue"
	}
	
	def inEventQueue() {
		"in_event_queue"
	}
	
	def dispatchEventFctID(ExecutionFlow it) {
		'''«functionPrefix»dispatch_event'''
	}
	
	def nextEventFctID(ExecutionFlow it) {
		'''«functionPrefix»get_next_event'''
	}

	def dispatchNextEventFctID(ExecutionFlow it) {
		'''«functionPrefix»dispatch_next_event'''
	}
	
	def addToQueueFctID(ExecutionFlow it) {
		'''«functionPrefix»add_event_to_queue'''
	}
	
	def addToQueueValueFctID(ExecutionFlow it) {
		'''«functionPrefix»add_value_event_to_queue'''
	}
	
	def getTimedEventNameFctID(ExecutionFlow it) {
		'''«functionPrefix»get_timed_event_name'''
	}
	
	def eventType(Event it) { if(hasValue) return '''_«typeSpecifier.targetLanguageName»''' }
	
}
