/**
 * Copyright (c) 2020-2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.SexecBuilder

/**
 * This class defines the general concept of entering a state machine. 
 * 
 * @author aterfloth
 */
class EnterMethod {

	public static val TRACE_ENTER = StateMachineBehaviorConcept.CONCEPT_NAME_PREFIX + "traceEnter"
	public static val ENTER = "enter"

	@Inject protected extension ExecutionGuard
	@Inject protected extension EventProcessing
	@Inject protected extension InitializedCheck

	@Inject protected extension SExecExtensions
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension SexecBuilder
	
	@Inject protected extension CompletionEvent
	@Inject protected extension SuperStep
	@Inject protected extension MicroStep
	@Inject protected extension RunCycleMethod
	
	def defineFeatures (ExecutionFlow it) {
		defineEnter	
	}
	
	def defineEnter(ExecutionFlow it) {
		
		it._method(ENTER) => [ m |
			m._public
			m._type(_void)
			m._body(
				_isInitializedCheck,
				_guardExecution( _sequence(
					_traceEnter,
					enterSequences.defaultSequence._clone,
					_superStepLoop(
						_completionLoop(
							_sequence(
								if (microStep.exists) microStep._call.toStep else _empty,
								_clearCurrentEvents
							)
						)
					)._when(hasCompletionTransition || appliesSuperStep)										
				))
			)
			m.body.comment = "Activates the state machine."
		]
	}

	def Step _traceEnter(ExecutionFlow it) {
		_conceptSequence(TRACE_ENTER)	
	}
	
	
	def Method enter(ExecutionFlow it) {
		features.filter( typeof(Method) ).filter( m | m.name == ENTER).head
	}
	
}
