/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.SexecBuilder

/**
 * This class defines the general concept of exiting a state machine. 
 * 
 * @author aterfloth
 */
class ExitMethod {

	public static val TRACE_EXIT = StateMachineBehaviorConcept.CONCEPT_NAME_PREFIX + "traceExit"
	public static val EXIT = "exit"

	@Inject protected extension ExecutionGuard
	@Inject protected extension EventProcessing

	@Inject protected extension SExecExtensions
	@Inject protected extension TypeBuilder
	@Inject protected extension SexecBuilder
	
	def defineFeatures (ExecutionFlow it) {
		defineExit	
	}
	
	def defineExit(ExecutionFlow it) {
		
		it._method(EXIT) => [ m |
			m._public
			m._type(_void)
			m._body(
				_guardExecution( _sequence(
					_traceExit,
					exitSequence._clone
				))
			)
			m.body.comment = "Deactivates the state machine."
		]
	}

	def Step _traceExit(ExecutionFlow it) {
		_conceptSequence(TRACE_EXIT)	
	}
	
	def Method exit(ExecutionFlow it) {
		features.filter( typeof(Method) ).filter( m | m.name == EXIT).head
	}
	
	
}