/**
 *   Copyright (c) 2022 committers of itemis CREATE.
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *   
 *   Contributors:
 * 		@author René Beckmann (beckmann@itemis.de)
 */

package com.yakindu.sct.model.sexec.naming

import java.util.ArrayList
import java.util.List
import com.google.inject.Inject
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.naming.QualifiedName
import com.yakindu.base.base.NamedElement
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionNode
import com.yakindu.sct.model.sexec.ExecutionScope
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.Reaction
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.Region
import com.yakindu.sct.model.sgraph.Vertex
import com.yakindu.sct.model.stext.naming.StextNameProvider

class ElementNameProvider {
	@Inject StextNameProvider provider
	@Inject protected extension SExecExtensions

	def List<String> elementNameSegments(NamedElement e) {
		val name = elementName(e);
		var ArrayList<String> l;
		if (name !== null) {
			l = new ArrayList<String>(name.getSegments());
		} else {
			l = new ArrayList<String>();
		}

		return l;
	}

	def protected dispatch QualifiedName elementName(ExecutionFlow it) {
		return null;
	}

	def protected dispatch QualifiedName elementName(ExecutionScope it) {
		return sourceElement.elementName()
	}

	def protected dispatch QualifiedName elementName(ExecutionState it) {
		return sourceElement.elementName()
	}

	def protected dispatch QualifiedName elementName(EObject it) {
		eContainer?.elementName()
	}

	def protected dispatch QualifiedName elementName(ExecutionNode it) {
		return provider.getFullyQualifiedName(it).skipFirst(2)
	}

	// TODO: we should merge the region/vertex case into this base implementation; we should check whether it is used in any case at all (otherwise it could be replaced with the body of vertexOrRegionName)
	def protected dispatch QualifiedName elementName(NamedElement it) {
		return provider.getFullyQualifiedName(it).skipFirst(2)
	}

	def protected dispatch QualifiedName elementName(Reaction it) {
		provider.getFullyQualifiedName(it).skipFirst(2)
	}

	def protected dispatch QualifiedName elementName(Region it) {
		val regionQualifier = QualifiedName.create("region")
		return regionQualifier.append(provider.getFullyQualifiedName(it).skipFirst(1))
	}

	def protected dispatch QualifiedName elementName(Step it) {
		var parentName = eContainer.elementName
		// parent name may be null
		if (( isEnterSequence || isCheckFunction || isEffect ) && (name !== null) && (!name.trim.empty))
			parentName.append(name)
		else
			parentName
	}

	def protected dispatch QualifiedName elementName(Vertex it) {
		return provider.getFullyQualifiedName(it).skipFirst(1)
	}
	
	def protected dispatch QualifiedName elementName(Method it) {
		val parentFqn = eContainer.elementName
	
		return 
			if (parentFqn === null) 
				provider.getFullyQualifiedName(it)
			else
				parentFqn.append(name)
	}

}
