/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.transformation

import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.ExecutionRegion
import com.yakindu.sct.model.sexec.ExecutionScope
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.Reaction
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.SexecFactory
import com.yakindu.sct.model.sexec.Step

class SexecFactoryExtensions {

	def factory() { SexecFactory::eINSTANCE }

	def newEnterStateStep(ExecutionState s) {
		var EnterState ess
		if (s !== null) {
			ess = factory.createEnterState
			ess.state = s
		}
		return ess
	}

	def newExitStateStep(ExecutionState s) {
		var ExitState ess
		if (s !== null) {
			ess = factory.createExitState
			ess.state = s
		}
		return ess
	}

	def newCase(ExecutionState it, Step step) {
		val sCase = factory.createStateCase
		sCase.state = it
		sCase.step = step
		return sCase
	}

	def newSaveHistory(ExecutionRegion r) {
		val save = factory.createSaveHistory
		save.region = r
		return save
	}

	def parentScopes(ExecutionScope scope) {
		val parents = <ExecutionScope>newArrayList
		var s = scope
		while (s !== null) {
			parents.add(s)
			s = s.superScope
		}
		return parents
	}

	def unchecked(Reaction it) {
		return (check === null || check.condition === null )
	}

	def dispatch boolean isEmpty(Sequence it) {
		if (steps.size > 0) {
			return steps.forall[isEmpty]
		}
		return true
	}

	def dispatch boolean isEmpty(Step it) {
		return false
	}

	def dispatch boolean isEmpty(If it) {
		return thenStep === null || thenStep.isEmpty
	}
	
}
