/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Robin Herrmann - itemis AG
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.AbstractSubchartInitializer
import java.util.stream.Collectors
import com.google.inject.Singleton
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

/**
 * @author Robin Herrmann - initial API and contribution
 */
@Singleton
class CppSubchartInitializer extends AbstractSubchartInitializer {

	@Inject protected extension SCTUnitCppNaming
	@Inject protected extension CppNaming
	@Inject protected extension Literals
	@Inject protected extension CppPointers
	
	public var String declarationSequence = null
	public var String setRunnerSequence = null
	
	override beginVisit(Object element, Object parent, int depth) {
		if (element instanceof VariableDefinition) {
			val subchart = getStatechart(element)
			if (!EcoreUtil.equals(subchart, root) && !element.isInternal) {
				variableStack.push(element)
				buildDelcarationSequence(subchart, element)
				buildInitSequence(subchart, element)
				buildSetRunnerSequence(subchart, element)
				buildImports(subchart)
				buildTeardownSequence(subchart, element)
				subcharts += subchart				
			}
		}
	}
	
	override synchronized perform(Object root) {
		declarationSequence = ""
		setRunnerSequence = ""
		super.perform(root)
	}
	
	def getSubchartDeclarationSequence(Statechart it) {
		declarationSequence ?: {
			perform
			declarationSequence
		}
	}
	
	def getSetRunnerSequence(Statechart it) {
		setRunnerSequence ?: {
			perform
			setRunnerSequence
		}
	}
	
	def currentSubchartVariable() {
		variableStack.listIterator.join("", "_", "", [elem|elem.name])
	}
	
	def void buildDelcarationSequence(Statechart subchart, VariableDefinition element) {
		val variableName = currentSubchartVariable()
		declarationSequence += subchartDeclaration(subchart, variableName)
	}
	
	override void buildTeardownSequence(Statechart subchart, VariableDefinition element) {
		val variableName = currentSubchartVariable()
		teardownSequence = teardownSubchart(subchart, variableName) + teardownSequence;
	}

	override buildInitSequence(Statechart subchart, VariableDefinition element) {
		val getParentChain = variableStack.listIterator.take(variableStack.length - 1).join("", "->", "->", [getter])
		val getElementChain = variableStack.listIterator.join("", "->", "->", [getter])
		val variableName = variableStack.listIterator.join("", "_", "", [elem|elem.name])
		initSequence += '''
			«subchart.newSubchart(variableName)»
			«ref»«getParentChain»«element.setter»(«subchart.accessSubchart(variableName)»);
			«IF subchart.isTimed»
				«maximalParallelTimeEvents» += (size_t)«ref»«getElementChain»«GET_PARALLEL_TIME_EVENTS_COUNT»();
			«ENDIF»
		'''
	}
	
	def buildSetRunnerSequence(Statechart subchart, VariableDefinition element) {
		val getElementChain = variableStack.listIterator.join("", "->", "->", [getter])
		setRunnerSequence += '''
			«IF subchart.isTimed»
				«ref»«getElementChain»«SET_TIMER_SERVICE»(runner);
			«ENDIF»
		'''
	}
	
	def distinctReferencedSubcharts(Statechart it) {
		return referencedSubcharts.stream().distinct().collect(Collectors.toList)
	}
	
	
	protected def subchartDeclaration(Statechart it, String variableName) {
		'''
		«typeName» «pointerType» «variableName» = «NULL_LITERAL»;
		'''
	}
	
	protected def accessSubchart(Statechart it, String variableName) {
		'''«variableName»'''
	}

	protected def getter(VariableDefinition it) {
		'''«context»«valueGetter»()'''
	}

	protected def setter(VariableDefinition it) {
		'''«context»«valueSetter»'''
	}

	protected def context(VariableDefinition it) {
		val container = eContainer
		return container.ifaceGetter
	}
	
	def dispatch ifaceGetter(InterfaceScope it) {
		if (name !== null) {
			return '''«asGetter»()«ifaceAcces»'''
		}
		''''''	
	}
	
	def dispatch ifaceGetter(EObject it) {
		''''''
	}
	
	def newSubchart(Statechart subchart, String variableName){
		'''«variableName» = new «subchart.typeName»();'''
	}
	
	protected def teardownSubchart(Statechart it, String variableName) {
		'''
		«deletePointer» «variableName»«freePointer»;
		'''
	}		
}
