/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.google.inject.name.Named
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sctunit.generator.c.extensions.GenerationHelper
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.generator.IFileSystemAccess

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

class GTest {

	public val static String SCTUNIT_INFERRER = "com.yakindu.sctunit.generator.cpp.CPPSCTUnitGenerator.typeInferrer"

	@Inject protected extension SCTUnitCppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppNaming
	@Inject protected extension CppPointers
	@Inject protected extension GenerationHelper
	@Inject protected extension CppMockingExtensions

	@Inject extension CppNavigationExtensions
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension CppStatementExtensions
	@Inject extension CSCTUnitGenmodelEntries
	@Inject extension StatechartAnnotations
	@Inject extension CppSubchartInitializer
	@Inject protected GenmodelEntriesExtension genModelExtension
	
	@Inject @Named(SCTUNIT_INFERRER) extension ITypeSystemInferrer
	@Inject GeneratorEntry entry
	

	def generateGTest(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
		var gTestFileName = '''«testClassName.cc»'''.toString
		var content = generateGTest
		fsa.generateFile(gTestFileName, content)
	}

	// TODO: Check if gmock provides a @Before method
	def private generateGTest(SCTUnitClass it) {
		'''
			«entry.licenseText»
			#include <string>
			#include <list>
			«IF isMockingRequired»
				#include <algorithm>
			«ENDIF»
			#include "gtest/gtest.h"
			#include "«statechart.module.h»"
			#include "«timerServiceFileName.h»"
			#include "«typesModule.h»"
			
			#define SC_UNUSED(P) (void)P
			
			«IF namespace !== null && namespace != ""»
				«FOR name : namespace.toString.split("\\.")»
					namespace «name» {
				«ENDFOR»
			«ENDIF»
			
			«generateSetUpTearDownClass»
			
			«IF !mockedExternalOperations.empty»«testClassName»* «testClassName»::current = 0;«ENDIF»
			
			«FOR operation : allAnnotationlessOps»
				«operation.generate(it)»
			«ENDFOR»
			
			«FOR operation : allTestOps»
				«operation.generate(it)»
			«ENDFOR»
			
			«IF namespace !== null»
			«FOR name : namespace.toString.split("\\.")»
				}
			«ENDFOR»
			
			«generateRequiredHeaderOperations»
			«ENDIF»
		'''
	}

	def private generate(SCTUnitOperation it, SCTUnitClass clazz) {
		'''
			«IF isTest»
				«IF !isCalledTestOperation»
					TEST_F(«SCTUnitClass.testClassName», «IF isIgnore»DISABLED_«ENDIF»«name») {
						«generateMethodBody»
				«ELSE»
					void «SCTUnitClass.testClassName»::«name»() {
						«generateMethodBody»
					}
					TEST_F(«SCTUnitClass.testClassName», «IF isIgnore»DISABLED_«ENDIF»«name») {
						«name»();
				«ENDIF»
			«ELSE»
				«infer.type.targetLanguageName» «SCTUnitClass.testClassName»::«name»(«generateParams»){
					«generateMethodBody»
			«ENDIF»
			}
		'''
	}

	def setupOperationMockInstances(SCTUnitClass it) {
		val mockOperations = getAllOperations(allMockStatementsInClass).toList
		'''
			«FOR op : mockOperations»
			«op.initializeOperationMock(it.isOperationForStatement(op, typeof(MockReturnStatement)))»
			«ENDFOR»
		'''
	}

	def protected generateSCUnitMethodDefinitions(SCTUnitClass it) {
		'''
			«FOR op : SCTUnitOperations.filter[(isCalledTestOperation || !isTest)]»
				«op.infer.type.targetLanguageName» «op.name»(«op.generateParams»);
			«ENDFOR»
		'''
	}

	def private generateSetUpTearDownClass(SCTUnitClass it) {
		'''	
			class «testClassName» : public ::testing::Test{
				public:
				«IF !mockedExternalOperations.empty»static «testClassName»* current;«ENDIF»
				«generateSCUnitMethodDefinitions»
					
				protected:
				«sharedPtr»«statechart.typeName»«pointerType» «identifier»;
				«statechart.subchartDeclarationSequence»
				
				«FOR vardef : variableDefinitions»
					«vardef.generate»
				«ENDFOR»
				
				public:
				«generateOperationMockClasses»
				«generateMockClasses»
				
				«generateTimerServiceVars»
				
				«defineInterfaceMockObjects»
				
				virtual void SetUp() {
					«IF !mockedExternalOperations.empty»current = this;«ENDIF»
					«identifier» = «makeSharedPtr»«statechart.typeName»«makeTypeCloser»();
					«IF statechart.timed || statechart.hasTimedSubmachines»
					size_t «maximalParallelTimeEvents» = «IF statechart.timed»(size_t)«identifier»->«GET_PARALLEL_TIME_EVENTS_COUNT»()«ELSE»0«ENDIF»;
					«ENDIF»
					«statechart.subchartInitSequence»
					«generateTimerServiceInit»
					«setupOperationMockInstances»
					«setupInterfaceMockInstances»
					«setupInterfaceCallbacks»
				}
				virtual void TearDown() {
					«FOR op : getAllOperations(allMockStatementsInClass).toList.reverse»
					«op.freeOperationMock»
					«ENDFOR»
					«deletePointer» «identifier»«freePointer»;
					«statechart.subchartTeardownSequence»
					«tearDownInterfaceMockInstances»
					«deletePointer» runner«freePointer»;
				}
			};
		'''
	}

	def generateMethodBody(SCTUnitOperation it) {
		'''
			«FOR statement : body.code»
				«statement.generate»
				
			«ENDFOR»
		'''
	}

	def generateTimerServiceVars(SCTUnitClass it) {
		'''
			//! The timers are managed by a timer service. */
			«sharedPtr»«timerServiceClass» «pointerType» runner;
		'''
	}

	def boolean isCalledTestOperation(SCTUnitOperation it) {
		val clazz = EcoreUtil2.getContainerOfType(it, typeof(SCTUnitClass))
		var elemRefs = EcoreUtil2.getAllContentsOfType(clazz, typeof(ElementReferenceExpression))
		val allOpRefs = elemRefs.filter[ref|ref.reference instanceof SCTUnitOperation].map[ref|ref.reference].toList
		if (allOpRefs.contains(it)) {
			return true
		}
		return false;
	}

	def private generateParams(SCTUnitOperation it) {
		'''«FOR param : parameters SEPARATOR ', '»«param.typeSpecifier.targetLanguageName» «param.name»«»«ENDFOR»'''
	}

	def protected generateTimerServiceInit(SCTUnitClass it) {
		val cyclePeriod = it.statechart.cyclePeriod

		'''
			runner = «makeSharedPtr»«timerServiceClass»«makeTypeCloser»(
				«IF statechart.isCycleBased»«identifier»,
				«cyclePeriod»«IF statechart.timed || statechart.hasTimedSubmachines», «ENDIF»«ENDIF»
				«IF statechart.timed || statechart.hasTimedSubmachines»
				«maximalParallelTimeEvents»
				«ENDIF»
			);
			«IF timed»
				«identifier»->«SET_TIMER_SERVICE»(runner);
			«ENDIF»
			«statechart.setRunnerSequence»
		'''
	}
}
